/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.any23.cli.Rover;
import org.apache.any23.cli.ToolTestBase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class SimpleRoverTest
extends ToolTestBase {
    private static final String baseUri = "urn:test";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String filePath;

    @Parameterized.Parameters
    public static Collection<String[]> litsFiles() throws Exception {
        return Arrays.asList({"/org/apache/any23/extractor/yaml/simple-load.yml"}, {"/org/apache/any23/extractor/csv/test-comma.csv"});
    }

    public SimpleRoverTest(String filePath) {
        super(Rover.class);
        this.filePath = filePath;
    }

    @Test
    public void ref310Test() throws Exception {
        File outputFile = File.createTempFile("rover-test", ".ttl", this.tempDirectory);
        File logfile = File.createTempFile("test-log", ".txt", this.tempDirectory);
        int exitCode = this.runTool(String.format("-l %s -o %s -f turtle -e yaml,csv -d %s %s", logfile.getAbsolutePath(), outputFile.getAbsolutePath(), baseUri, this.copyResourceToTempFile(this.filePath).getAbsolutePath()));
        Assert.assertTrue((boolean)logfile.exists());
        Assert.assertTrue((boolean)outputFile.exists());
        String outputFileContent = FileUtils.readFileToString((File)outputFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((outputFileContent.length() > 10 ? 1 : 0) != 0);
        String[] logFileContent = FileUtils.readLines((File)logfile, (Charset)StandardCharsets.UTF_8).toArray(new String[0]);
        Assert.assertEquals((long)2L, (long)logFileContent.length);
        int contentSize = Integer.valueOf(logFileContent[1].split("\\t")[1]);
        String extractors = logFileContent[1].split("\\t")[4].replaceAll("[\\[\\]\\s:\\d]", "");
        if (log.isDebugEnabled()) {
            log.debug("Content: '{}'", (Object)contentSize);
            log.debug("Extractors: '{}'", (Object)extractors);
            log.debug("Log file location: {}", (Object)logfile.getAbsolutePath());
        }
        if (log.isTraceEnabled()) {
            log.trace("Log file content: \n{}\n", (Object)FileUtils.readFileToString((File)logfile, (Charset)StandardCharsets.UTF_8));
        }
        Assert.assertTrue((String)"Content size should be greated than 0", (contentSize > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)extractors.isEmpty());
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)exitCode);
    }

    @Test
    public void ref310ExtendedTest() throws Exception {
        File outputFile = File.createTempFile("rover-test", ".ttl", this.tempDirectory);
        int exitCode = this.runTool(String.format("-o %s -f turtle -e yaml,csv -d %s %s", outputFile.getAbsolutePath(), baseUri, this.copyResourceToTempFile(this.filePath).getAbsolutePath()));
        Assert.assertTrue((boolean)outputFile.exists());
        String outputFileContent = FileUtils.readFileToString((File)outputFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((outputFileContent.length() > 10 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unexpected exit code.", (long)0L, (long)exitCode);
    }
}

