/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli.flows;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.vocab.CSV;
import org.apache.any23.writer.CompositeTripleHandler;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleHandlerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeopleExtractor
extends CompositeTripleHandler {
    private Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final CSV csv = CSV.getInstance();
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    public static final String RAW_NS = "urn:dataser:raw/";
    private static final IRI RAW_FIRST_NAME = vf.createIRI("urn:dataser:raw/", "FirstName");
    private static final IRI RAW_LAST_NAME = vf.createIRI("urn:dataser:raw/", "LastName");
    private static final String NAMESPACE = "http://supercustom.net/ontology/";
    private static final IRI PERSON = vf.createIRI("http://supercustom.net/ontology/", "Person");
    private static final IRI FULL_NAME = vf.createIRI("http://supercustom.net/ontology/", "fullName");
    private static final IRI HASH = vf.createIRI("http://supercustom.net/ontology/", "hash");
    private final Model csvModel = new TreeModel();

    public static Model createPerson(String fullName) {
        IRI s = vf.createIRI("http://rdf.supercustom.net/data/", DigestUtils.sha1Hex((String)fullName));
        TreeModel model = new TreeModel();
        model.add((Resource)s, RDF.TYPE, (Value)PERSON, new Resource[0]);
        model.add((Resource)s, FULL_NAME, (Value)vf.createLiteral(fullName), new Resource[0]);
        model.add((Resource)s, HASH, (Value)vf.createLiteral(s.getLocalName(), XMLSchema.HEXBINARY), new Resource[0]);
        return model;
    }

    public PeopleExtractor(TripleHandler delegate) {
        super(Collections.singletonList(delegate));
    }

    public void receiveTriple(Resource s, IRI p, Value o, IRI g, ExtractionContext context) throws TripleHandlerException {
        if ("csv".equals(context.getExtractorName())) {
            this.csvModel.add(s, p, o, new Resource[]{vf.createIRI(context.getUniqueID())});
        } else {
            super.receiveTriple(s, p, o, g, context);
        }
    }

    public void closeContext(ExtractionContext context) throws TripleHandlerException {
        Set subjects = this.csvModel.filter(null, RDF.TYPE, (Value)PeopleExtractor.csv.rowType, new Resource[0]).stream().map(Statement::getSubject).collect(Collectors.toSet());
        this.log.debug("List of rows: {}", subjects);
        for (Resource rowId : subjects) {
            String firstName = Models.objectLiteral((Model)this.csvModel.filter(rowId, RAW_FIRST_NAME, null, new Resource[0])).map(Literal::getLabel).orElse("");
            String lastName = Models.objectLiteral((Model)this.csvModel.filter(rowId, RAW_LAST_NAME, null, new Resource[0])).map(Literal::getLabel).orElse("");
            String fullName = firstName + " " + lastName;
            for (Statement s : PeopleExtractor.createPerson(fullName)) {
                super.receiveTriple(s.getSubject(), s.getPredicate(), s.getObject(), null, context);
            }
        }
        this.csvModel.clear();
        super.closeContext(context);
    }
}

