/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.any23.cli.Rover;
import org.apache.any23.cli.ToolTestBase;
import org.apache.any23.cli.flows.PeopleExtractor;
import org.apache.any23.rdf.RDFUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorsFlowTest
extends ToolTestBase {
    private static final String testingDatafile = "/org/apache/any23/extractor/csv/test-comma.csv";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ExtractorsFlowTest() {
        super(Rover.class);
    }

    @Test
    public void runTestFor396() throws Exception {
        File outputFile = File.createTempFile("mockdata-", ".ttl", this.tempDirectory);
        File logFile = File.createTempFile("log-exec-", ".txt", this.tempDirectory);
        this.runTool(String.format("-l %s -o %s -f people,turtle -e csv -d %s %s", logFile.getAbsolutePath(), outputFile.getAbsolutePath(), "urn:dataser:raw/", this.copyResourceToTempFile(testingDatafile).getAbsolutePath()));
        TreeModel expected = new TreeModel();
        Stream.of("Davide Palmisano", "Michele Mostarda", "Giovanni Tummarello").map(PeopleExtractor::createPerson).forEach(arg_0 -> ((Model)expected).addAll(arg_0));
        if (log.isDebugEnabled()) {
            log.debug("\n\nlog file content:\n{}", (Object)FileUtils.readFileToString((File)logFile, (String)"utf-8"));
            log.debug("\n\nData file: \n{}", (Object)FileUtils.readFileToString((File)outputFile, (String)"utf-8"));
        }
        Assert.assertTrue((boolean)this.assertCompareModels((Model)expected, outputFile));
    }

    private boolean assertCompareModels(Model expected, File received) throws Exception {
        TreeModel receivedModel = new TreeModel();
        receivedModel.addAll(Arrays.asList(RDFUtils.parseRDF((RDFFormat)((RDFFormat)Rio.getParserFormatForFileName((String)received.getName()).orElseThrow(AssertionError::new)), (InputStream)new BufferedInputStream(new FileInputStream(received)), (String)received.toURI().toString())));
        return receivedModel.containsAll((Collection)expected);
    }
}

