/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.sampler.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.tool.sampler.plugins.CpuSamplerPlugin;

public class LinuxCpuSamplerPlugin
implements CpuSamplerPlugin,
Runnable {
    private Process vmstatProcess;
    private String vmstat;
    private String result = "";
    private final Object mutex = new Object();
    private AtomicBoolean stop = new AtomicBoolean(false);

    public LinuxCpuSamplerPlugin(long intervalInMs) {
        this.vmstat = "vmstat -n " + (int)(intervalInMs / 1000L);
    }

    @Override
    public void start() {
        this.stop.set(false);
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void stop() {
        this.stop.set(true);
        try {
            this.vmstatProcess.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.vmstatProcess = Runtime.getRuntime().exec(this.vmstat);
            BufferedReader br = new BufferedReader(new InputStreamReader(this.vmstatProcess.getInputStream()), 1024);
            br.readLine();
            String header = br.readLine();
            while (!this.stop.get()) {
                String data = br.readLine();
                if (data == null) continue;
                String csvData = this.convertToCSV(header, data);
                Object object = this.mutex;
                synchronized (object) {
                    this.result = csvData;
                }
            }
            br.close();
            this.vmstatProcess.destroy();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCpuUtilizationStats() {
        String data;
        Object object = this.mutex;
        synchronized (object) {
            data = this.result;
            this.result = "";
        }
        return data;
    }

    public String getVmstat() {
        return this.vmstat;
    }

    public void setVmstat(String vmstat) {
        this.vmstat = vmstat;
    }

    protected String convertToCSV(String header, String data) {
        StringTokenizer headerTokens = new StringTokenizer(header, " ");
        StringTokenizer dataTokens = new StringTokenizer(data, " ");
        String csv = "";
        while (headerTokens.hasMoreTokens()) {
            csv = csv + headerTokens.nextToken() + "=" + dataTokens.nextToken() + ",";
        }
        return csv;
    }
}

