/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import javax.jms.JMSException;
import org.apache.activemq.tool.AbstractJmsClientSystem;
import org.apache.activemq.tool.JmsProducerClient;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.JmsClientSystemProperties;
import org.apache.activemq.tool.properties.JmsProducerProperties;
import org.apache.activemq.tool.properties.JmsProducerSystemProperties;
import org.apache.activemq.tool.sampler.ThroughputSamplerTask;

public class JmsProducerSystem
extends AbstractJmsClientSystem {
    protected JmsProducerSystemProperties sysTest = new JmsProducerSystemProperties();
    protected JmsProducerProperties producer = new JmsProducerProperties();

    @Override
    public JmsClientSystemProperties getSysTest() {
        return this.sysTest;
    }

    @Override
    public void setSysTest(JmsClientSystemProperties sysTestProps) {
        this.sysTest = (JmsProducerSystemProperties)sysTestProps;
    }

    @Override
    public JmsClientProperties getJmsClientProperties() {
        return this.getProducer();
    }

    public JmsProducerProperties getProducer() {
        return this.producer;
    }

    public void setProducer(JmsProducerProperties producer) {
        this.producer = producer;
    }

    @Override
    protected void runJmsClient(String clientName, int clientDestIndex, int clientDestCount) {
        ThroughputSamplerTask sampler = this.getTpSampler();
        JmsProducerClient producerClient = new JmsProducerClient(this.producer, this.jmsConnFactory);
        producerClient.setClientName(clientName);
        if (sampler != null) {
            sampler.registerClient(producerClient);
        }
        try {
            producerClient.sendMessages(clientDestIndex, clientDestCount);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JmsProducerSystem sys = new JmsProducerSystem();
        sys.configureProperties(AbstractJmsClientSystem.parseStringArgs(args));
        try {
            sys.runSystemTest();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

