/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import org.apache.activemq.tool.AbstractJmsMeasurableClient;
import org.apache.activemq.tool.properties.JmsClientProperties;
import org.apache.activemq.tool.properties.JmsProducerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsProducerClient
extends AbstractJmsMeasurableClient {
    private static final Logger LOG = LoggerFactory.getLogger(JmsProducerClient.class);
    protected JmsProducerProperties client;
    protected MessageProducer jmsProducer;
    protected TextMessage jmsTextMessage;

    public JmsProducerClient(ConnectionFactory factory) {
        this(new JmsProducerProperties(), factory);
    }

    public JmsProducerClient(JmsProducerProperties clientProps, ConnectionFactory factory) {
        super(factory);
        this.client = clientProps;
    }

    public void sendMessages() throws JMSException {
        if (this.client.getSendType().equalsIgnoreCase("count")) {
            this.sendCountBasedMessages(this.client.getSendCount());
        } else {
            this.sendTimeBasedMessages(this.client.getSendDuration());
        }
    }

    public void sendMessages(int destCount) throws JMSException {
        this.destCount = destCount;
        this.sendMessages();
    }

    public void sendMessages(int destIndex, int destCount) throws JMSException {
        this.destIndex = destIndex;
        this.sendMessages(destCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCountBasedMessages(long messageCount) throws JMSException {
        Destination[] dest = this.createDestination(this.destIndex, this.destCount);
        if (this.getJmsProducer() == null) {
            if (dest.length == 1) {
                this.createJmsProducer(dest[0]);
            } else {
                this.createJmsProducer();
            }
        }
        try {
            this.getConnection().start();
            if (this.client.getMsgFileName() != null) {
                LOG.info("Starting to publish " + messageCount + " messages from file " + this.client.getMsgFileName());
            } else {
                LOG.info("Starting to publish " + messageCount + " messages of size " + this.client.getMessageSize() + " byte(s).");
            }
            if (!this.client.isCreateNewMsg()) {
                this.createJmsTextMessage();
                if (dest.length > 1) {
                    int i = 0;
                    while ((long)i < messageCount) {
                        for (int j = 0; j < dest.length; ++j) {
                            this.getJmsProducer().send(dest[j], (Message)this.getJmsTextMessage());
                            this.incThroughput();
                            this.sleep();
                            this.commitTxIfNecessary();
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < messageCount) {
                        this.getJmsProducer().send((Message)this.getJmsTextMessage());
                        this.incThroughput();
                        this.sleep();
                        this.commitTxIfNecessary();
                        ++i;
                    }
                }
            } else if (dest.length > 1) {
                int i = 0;
                while ((long)i < messageCount) {
                    for (int j = 0; j < dest.length; ++j) {
                        this.getJmsProducer().send(dest[j], (Message)this.createJmsTextMessage("Text Message [" + i + "]"));
                        this.incThroughput();
                        this.sleep();
                        this.commitTxIfNecessary();
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < messageCount) {
                    this.getJmsProducer().send((Message)this.createJmsTextMessage("Text Message [" + i + "]"));
                    this.incThroughput();
                    this.sleep();
                    this.commitTxIfNecessary();
                    ++i;
                }
            }
        }
        finally {
            this.getConnection().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTimeBasedMessages(long duration) throws JMSException {
        long endTime = System.currentTimeMillis() + duration;
        Destination[] dest = this.createDestination(this.destIndex, this.destCount);
        if (this.getJmsProducer() == null) {
            if (dest.length == 1) {
                this.createJmsProducer(dest[0]);
            } else {
                this.createJmsProducer();
            }
        }
        try {
            this.getConnection().start();
            if (this.client.getMsgFileName() != null) {
                LOG.info("Starting to publish messages from file " + this.client.getMsgFileName() + " for " + duration + " ms");
            } else {
                LOG.info("Starting to publish " + this.client.getMessageSize() + " byte(s) messages for " + duration + " ms");
            }
            if (!this.client.isCreateNewMsg()) {
                this.createJmsTextMessage();
                if (dest.length > 1) {
                    while (System.currentTimeMillis() < endTime) {
                        for (int j = 0; j < dest.length; ++j) {
                            this.getJmsProducer().send(dest[j], (Message)this.getJmsTextMessage());
                            this.incThroughput();
                            this.sleep();
                            this.commitTxIfNecessary();
                        }
                    }
                } else {
                    while (System.currentTimeMillis() < endTime) {
                        this.getJmsProducer().send((Message)this.getJmsTextMessage());
                        this.incThroughput();
                        this.sleep();
                        this.commitTxIfNecessary();
                    }
                }
            } else {
                long count = 1L;
                if (dest.length > 1) {
                    while (System.currentTimeMillis() < endTime) {
                        for (int j = 0; j < dest.length; ++j) {
                            this.getJmsProducer().send(dest[j], (Message)this.createJmsTextMessage("Text Message [" + count++ + "]"));
                            this.incThroughput();
                            this.sleep();
                            this.commitTxIfNecessary();
                        }
                    }
                } else {
                    while (System.currentTimeMillis() < endTime) {
                        this.getJmsProducer().send((Message)this.createJmsTextMessage("Text Message [" + count++ + "]"));
                        this.incThroughput();
                        this.sleep();
                        this.commitTxIfNecessary();
                    }
                }
            }
        }
        finally {
            this.getConnection().close();
        }
    }

    public MessageProducer createJmsProducer() throws JMSException {
        this.jmsProducer = this.getSession().createProducer(null);
        if (this.client.getDeliveryMode().equalsIgnoreCase("persistent")) {
            LOG.info("Creating producer to possible multiple destinations with persistent delivery.");
            this.jmsProducer.setDeliveryMode(2);
        } else if (this.client.getDeliveryMode().equalsIgnoreCase("nonpersistent")) {
            LOG.info("Creating producer to possible multiple destinations with non-persistent delivery.");
            this.jmsProducer.setDeliveryMode(1);
        } else {
            LOG.warn("Unknown deliveryMode value. Defaulting to non-persistent.");
            this.jmsProducer.setDeliveryMode(1);
        }
        return this.jmsProducer;
    }

    public MessageProducer createJmsProducer(Destination dest) throws JMSException {
        this.jmsProducer = this.getSession().createProducer(dest);
        if (this.client.getDeliveryMode().equalsIgnoreCase("persistent")) {
            LOG.info("Creating producer to: " + dest.toString() + " with persistent delivery.");
            this.jmsProducer.setDeliveryMode(2);
        } else if (this.client.getDeliveryMode().equalsIgnoreCase("nonpersistent")) {
            LOG.info("Creating  producer to: " + dest.toString() + " with non-persistent delivery.");
            this.jmsProducer.setDeliveryMode(1);
        } else {
            LOG.warn("Unknown deliveryMode value. Defaulting to non-persistent.");
            this.jmsProducer.setDeliveryMode(1);
        }
        return this.jmsProducer;
    }

    public MessageProducer getJmsProducer() {
        return this.jmsProducer;
    }

    public TextMessage createJmsTextMessage() throws JMSException {
        if (this.client.getMsgFileName() != null) {
            return this.loadJmsMessage();
        }
        return this.createJmsTextMessage(this.client.getMessageSize());
    }

    public TextMessage createJmsTextMessage(int size) throws JMSException {
        this.jmsTextMessage = this.getSession().createTextMessage(this.buildText("", size));
        Set<String> headerKeys = this.client.getHeaderKeys();
        for (String key : headerKeys) {
            this.jmsTextMessage.setObjectProperty(key, this.client.getHeaderValue(key));
        }
        return this.jmsTextMessage;
    }

    public TextMessage createJmsTextMessage(String text) throws JMSException {
        this.jmsTextMessage = this.getSession().createTextMessage(this.buildText(text, this.client.getMessageSize()));
        return this.jmsTextMessage;
    }

    public TextMessage getJmsTextMessage() {
        return this.jmsTextMessage;
    }

    @Override
    public JmsClientProperties getClient() {
        return this.client;
    }

    @Override
    public void setClient(JmsClientProperties clientProps) {
        this.client = (JmsProducerProperties)clientProps;
    }

    protected String buildText(String text, int size) {
        byte[] data = new byte[size - text.length()];
        Arrays.fill(data, (byte)0);
        return text + new String(data);
    }

    protected void sleep() {
        if (this.client.getSendDelay() > 0L) {
            try {
                LOG.trace("Sleeping for " + this.client.getSendDelay() + " milliseconds");
                Thread.sleep(this.client.getSendDelay());
            }
            catch (InterruptedException ex) {
                LOG.warn(ex.getMessage());
            }
        }
    }

    protected TextMessage loadJmsMessage() throws JMSException {
        try {
            if (this.client.getMsgFileName() == null) {
                throw new JMSException("Invalid filename specified.");
            }
            File f = new File(this.client.getMsgFileName());
            if (f.isDirectory()) {
                throw new JMSException("Cannot load from " + this.client.getMsgFileName() + " as it is a directory not a text file.");
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            StringBuffer payload = new StringBuffer();
            String tmp = null;
            while ((tmp = br.readLine()) != null) {
                payload.append(tmp);
            }
            this.jmsTextMessage = this.getSession().createTextMessage(payload.toString());
            return this.jmsTextMessage;
        }
        catch (FileNotFoundException ex) {
            throw new JMSException(ex.getMessage());
        }
        catch (IOException iox) {
            throw new JMSException(iox.getMessage());
        }
    }
}

