/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.sampler;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.tool.properties.AbstractObjectProperties;
import org.apache.activemq.tool.reports.PerformanceReportWriter;
import org.apache.activemq.tool.sampler.PerformanceEventListener;
import org.apache.activemq.tool.sampler.PerformanceSampler;

public abstract class AbstractPerformanceSampler
extends AbstractObjectProperties
implements PerformanceSampler {
    protected long rampUpTime = 30000L;
    protected long rampDownTime = 30000L;
    protected long duration = 300000L;
    protected long interval = 1000L;
    protected PerformanceReportWriter perfReportWriter = null;
    protected PerformanceEventListener perfEventListener = null;
    protected final AtomicBoolean isRunning = new AtomicBoolean(false);
    protected long sampleIndex = 0L;

    public long getRampUpTime() {
        return this.rampUpTime;
    }

    public void setRampUpTime(long rampUpTime) {
        this.rampUpTime = rampUpTime;
    }

    public long getRampDownTime() {
        return this.rampDownTime;
    }

    public void setRampDownTime(long rampDownTime) {
        this.rampDownTime = rampDownTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public PerformanceReportWriter getPerfReportWriter() {
        return this.perfReportWriter;
    }

    public void setPerfReportWriter(PerformanceReportWriter perfReportWriter) {
        this.perfReportWriter = perfReportWriter;
    }

    public PerformanceEventListener getPerfEventListener() {
        return this.perfEventListener;
    }

    public void setPerfEventListener(PerformanceEventListener perfEventListener) {
        this.perfEventListener = perfEventListener;
    }

    public void startSampler() {
        this.isRunning.set(true);
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.onRampUpStart();
            if (this.perfEventListener != null) {
                this.perfEventListener.onRampUpStart(this);
            }
            try {
                Thread.sleep(this.rampUpTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.onSamplerStart();
            if (this.perfEventListener != null) {
                this.perfEventListener.onSamplerStart(this);
            }
            this.sample();
            this.onSamplerEnd();
            if (this.perfEventListener != null) {
                this.perfEventListener.onSamplerEnd(this);
            }
            try {
                Thread.sleep(this.rampDownTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.onRampDownEnd();
            if (this.perfEventListener != null) {
                this.perfEventListener.onRampDownEnd(this);
            }
        }
        finally {
            this.isRunning.set(false);
            AtomicBoolean atomicBoolean = this.isRunning;
            synchronized (atomicBoolean) {
                this.isRunning.notifyAll();
            }
        }
    }

    protected void sample() {
        long endTime = System.currentTimeMillis() + this.duration - this.rampDownTime - this.rampUpTime;
        while (System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.sampleData();
            ++this.sampleIndex;
        }
    }

    public abstract void sampleData();

    public boolean isRunning() {
        return this.isRunning.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        while (this.isRunning()) {
            try {
                AtomicBoolean atomicBoolean = this.isRunning;
                synchronized (atomicBoolean) {
                    this.isRunning.wait(0L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onRampUpStart() {
    }

    protected void onSamplerStart() {
    }

    protected void onSamplerEnd() {
    }

    protected void onRampDownEnd() {
    }
}

