/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.activemq.tool.properties.ReflectionConfigurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static void configureClass(Object obj, String key, String val) {
        try {
            Object target = obj;
            Class<?> targetClass = obj.getClass();
            String debugInfo = "Invoking: " + targetClass.getName();
            StringTokenizer tokenizer = new StringTokenizer(key, ".");
            String keySubString = key;
            int tokenCount = tokenizer.countTokens();
            for (int j = 0; j < tokenCount - 1; ++j) {
                String name = tokenizer.nextToken();
                if (target instanceof ReflectionConfigurable && !((ReflectionConfigurable)target).acceptConfig(keySubString, val)) {
                    return;
                }
                keySubString = keySubString.substring(name.length() + 1);
                String getMethod = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = targetClass.getMethod(getMethod, new Class[0]);
                target = method.invoke(target, null);
                targetClass = target.getClass();
                debugInfo = debugInfo + "." + getMethod + "()";
            }
            String property = tokenizer.nextToken();
            if (target instanceof ReflectionConfigurable && !((ReflectionConfigurable)target).acceptConfig(property, val)) {
                return;
            }
            Method setterMethod = ReflectionUtil.findSetterMethod(targetClass, property);
            if (setterMethod == null) {
                throw new IllegalAccessException("Unable to find appropriate setter method signature for property: " + property);
            }
            Class<?> paramType = setterMethod.getParameterTypes()[0];
            debugInfo = debugInfo + "." + setterMethod + "(" + paramType.getName() + ": " + val + ")";
            if (paramType.isPrimitive()) {
                if (paramType == Boolean.TYPE) {
                    setterMethod.invoke(target, Boolean.valueOf(val));
                } else if (paramType == Integer.TYPE) {
                    setterMethod.invoke(target, Integer.valueOf(val));
                } else if (paramType == Long.TYPE) {
                    setterMethod.invoke(target, Long.valueOf(val));
                } else if (paramType == Double.TYPE) {
                    setterMethod.invoke(target, Double.valueOf(val));
                } else if (paramType == Float.TYPE) {
                    setterMethod.invoke(target, Float.valueOf(val));
                } else if (paramType == Short.TYPE) {
                    setterMethod.invoke(target, Short.valueOf(val));
                } else if (paramType == Byte.TYPE) {
                    setterMethod.invoke(target, Byte.valueOf(val));
                } else if (paramType == Character.TYPE) {
                    setterMethod.invoke(target, new Character(val.charAt(0)));
                }
            } else if (paramType == String.class) {
                setterMethod.invoke(target, val);
            } else {
                Constructor<?> c = paramType.getConstructor(String.class);
                Object paramObject = c.newInstance(val);
                setterMethod.invoke(target, paramObject);
            }
            LOG.debug(debugInfo);
        }
        catch (Exception e) {
            LOG.warn(e.toString());
        }
    }

    public static void configureClass(Object obj, Properties props) {
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            try {
                String key = (String)i.next();
                String val = props.getProperty(key);
                ReflectionUtil.configureClass(obj, key, val);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static Properties retrieveObjectProperties(Object obj) {
        Properties props = new Properties();
        try {
            props.putAll((Map<?, ?>)ReflectionUtil.retrieveClassProperties("", obj.getClass(), obj));
        }
        catch (Exception e) {
            LOG.warn(e.toString());
        }
        return props;
    }

    protected static Properties retrieveClassProperties(String prefix, Class targetClass, Object targetObject) {
        if (targetClass == null || targetObject == null) {
            return new Properties();
        }
        Properties props = new Properties();
        Method[] getterMethods = ReflectionUtil.findAllGetterMethods(targetClass);
        for (int i = 0; i < getterMethods.length; ++i) {
            try {
                Object val;
                String propertyName = ReflectionUtil.getPropertyName(getterMethods[i].getName());
                Class<?> retType = getterMethods[i].getReturnType();
                if (retType.isPrimitive() || retType == String.class) {
                    if (ReflectionUtil.findSetterMethod(targetClass, propertyName) == null) continue;
                    val = null;
                    try {
                        val = getterMethods[i].invoke(targetObject, null);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    props.setProperty(prefix + propertyName, val + "");
                    continue;
                }
                try {
                    val = getterMethods[i].invoke(targetObject, null);
                    if (val == null || val == targetObject) continue;
                    props.putAll((Map<?, ?>)ReflectionUtil.retrieveClassProperties(propertyName + ".", val.getClass(), val));
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return props;
    }

    private static Method findSetterMethod(Class targetClass, String propertyName) {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName) || !ReflectionUtil.isSetterMethod(methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    private static Method findGetterMethod(Class targetClass, String propertyName) {
        String methodName1 = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String methodName2 = "is" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName1) && !methods[i].getName().equals(methodName2) || !ReflectionUtil.isGetterMethod(methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    private static Method[] findAllGetterMethods(Class targetClass) {
        ArrayList<Method> getterMethods = new ArrayList<Method>();
        Method[] methods = targetClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!ReflectionUtil.isGetterMethod(methods[i])) continue;
            getterMethods.add(methods[i]);
        }
        return getterMethods.toArray(new Method[0]);
    }

    private static boolean isGetterMethod(Method method) {
        return (method.getName().startsWith("is") && method.getReturnType() == Boolean.TYPE || method.getName().startsWith("get") && method.getReturnType() != Void.TYPE) && method.getParameterTypes().length == 0 && method.getDeclaringClass() != Object.class;
    }

    private static boolean isSetterMethod(Method method) {
        Class<?>[] paramType;
        if (method.getName().startsWith("set") && method.getReturnType() == Void.TYPE && (paramType = method.getParameterTypes()).length == 1) {
            if (paramType[0].isPrimitive() || paramType[0] == String.class) {
                return true;
            }
            try {
                if (paramType[0].getConstructor(String.class) != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getPropertyName(String methodName) {
        String name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("set") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : ""));
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

