/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class QueueSessionTest
extends PTPTestCase {
    public void testRollbackRececeivedMessage() {
        try {
            this.senderConnection.stop();
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            Assert.assertEquals((Object)true, (Object)this.senderSession.getTransacted());
            this.sender = this.senderSession.createSender(this.senderQueue);
            this.senderConnection.start();
            this.receiverConnection.stop();
            this.receiverSession = this.receiverConnection.createQueueSession(true, 0);
            Assert.assertEquals((Object)true, (Object)this.receiverSession.getTransacted());
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.receiverConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testRollbackRececeivedMessage");
            this.sender.send((Message)message);
            this.senderSession.commit();
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((Object)"testRollbackRececeivedMessage", (Object)msg.getText());
            Assert.assertEquals((Object)false, (Object)msg.getJMSRedelivered());
            this.receiverSession.rollback();
            m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            Assert.assertEquals((Object)"testRollbackRececeivedMessage", (Object)msg.getText());
            Assert.assertEquals((Object)true, (Object)msg.getJMSRedelivered());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testCreateBrowser_2() {
        try {
            this.senderSession.createBrowser(this.senderQueue, "definitely not a message selector!");
            Assert.fail((String)"Should throw a jakarta.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException invalidSelectorException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidSelectorException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateBrowser_1() {
        try {
            this.senderSession.createBrowser((Queue)null);
            Assert.fail((String)"Should throw a jakarta.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidDestinationException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateReceiver_2() {
        try {
            this.receiver = this.senderSession.createReceiver(this.senderQueue, "definitely not a message selector!");
            Assert.fail((String)"Should throw a jakarta.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException invalidSelectorException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidSelectorException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateReceiver_1() {
        try {
            this.receiver = this.senderSession.createReceiver((Queue)null);
            Assert.fail((String)"Should throw a jakarta.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidDestinationException, not a " + String.valueOf((Object)e)));
        }
    }

    public static Test suite() {
        return new TestSuite(QueueSessionTest.class);
    }

    public QueueSessionTest(String name) {
        super(name);
    }
}

