/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PubSubTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class TopicSessionTest
extends PubSubTestCase {
    public void testRollbackReceivedMessage() {
        try {
            this.publisherConnection.stop();
            this.publisherSession = this.publisherConnection.createTopicSession(true, 0);
            Assert.assertEquals((Object)true, (Object)this.publisherSession.getTransacted());
            this.publisher = this.publisherSession.createPublisher(this.publisherTopic);
            this.publisherConnection.start();
            this.subscriberConnection.stop();
            this.subscriberSession = this.subscriberConnection.createTopicSession(true, 0);
            Assert.assertEquals((Object)true, (Object)this.subscriberSession.getTransacted());
            this.subscriber = this.subscriberSession.createSubscriber(this.subscriberTopic);
            this.subscriberConnection.start();
            TextMessage message = this.publisherSession.createTextMessage();
            message.setText("testRollbackReceivedMessage");
            this.publisher.publish((Message)message);
            this.publisherSession.commit();
            Message msg1 = this.subscriber.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"no message received", (msg1 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(msg1 instanceof TextMessage));
            Assert.assertEquals((Object)"testRollbackReceivedMessage", (Object)((TextMessage)msg1).getText());
            this.subscriberSession.rollback();
            Message msg2 = this.subscriber.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"no message received after rollbacking subscriber session.", (msg2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(msg2 instanceof TextMessage));
            Assert.assertEquals((Object)"testRollbackReceivedMessage", (Object)((TextMessage)msg2).getText());
            this.subscriberSession.commit();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testDurableSubscriber() {
        try {
            this.subscriber = this.subscriberSession.createDurableSubscriber(this.subscriberTopic, "testTopic");
            this.subscriberConnection.close();
            this.subscriberConnection = null;
            TextMessage message = this.publisherSession.createTextMessage();
            message.setText("test");
            this.publisher.publish((Message)message);
            this.subscriberConnection = this.subscriberTCF.createTopicConnection();
            this.subscriberConnection.setClientID("subscriberConnection");
            this.subscriberSession = this.subscriberConnection.createTopicSession(false, 1);
            this.subscriber = this.subscriberSession.createDurableSubscriber(this.subscriberTopic, "testTopic");
            this.subscriberConnection.start();
            TextMessage m = (TextMessage)this.subscriber.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"test", (Object)m.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testUnsubscribe() {
        try {
            this.subscriber = this.subscriberSession.createDurableSubscriber(this.subscriberTopic, "topic");
            this.subscriber.close();
            this.subscriberSession.unsubscribe("topic");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testCreateDurableSubscriber_2() {
        try {
            this.subscriberSession.createDurableSubscriber(this.subscriberTopic, "topic", "definitely not a message selector!", true);
            Assert.fail((String)"Should throw a jakarta.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException invalidSelectorException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidSelectorException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateDurableSubscriber_1() {
        try {
            this.subscriberSession.createDurableSubscriber((Topic)null, "topic");
            Assert.fail((String)"Should throw a jakarta.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidDestinationException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateSubscriber_2() {
        try {
            this.subscriberSession.createSubscriber(this.subscriberTopic, "definitely not a message selector!", true);
            Assert.fail((String)"Should throw a jakarta.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException invalidSelectorException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidSelectorException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testCreateSubscriber_1() {
        try {
            this.subscriberSession.createSubscriber((Topic)null);
            Assert.fail((String)"Should throw a jakarta.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.InvalidDestinationException, not a " + String.valueOf((Object)e)));
        }
    }

    public static Test suite() {
        return new TestSuite(TopicSessionTest.class);
    }

    public TopicSessionTest(String name) {
        super(name);
    }
}

