/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.queue;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class TemporaryQueueTest
extends PTPTestCase {
    private TemporaryQueue tempQueue;
    private QueueReceiver tempReceiver;

    public void testTemporaryQueue() {
        try {
            this.senderConnection.stop();
            this.receiverConnection.stop();
            this.tempQueue = this.receiverSession.createTemporaryQueue();
            this.sender = this.senderSession.createSender(null);
            this.tempReceiver = this.receiverSession.createReceiver((Queue)this.tempQueue);
            this.receiverConnection.start();
            this.senderConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testTemporaryQueue");
            this.sender.send((Queue)this.tempQueue, (Message)message);
            Message m = this.tempReceiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((Object)"testTemporaryQueue", (Object)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(TemporaryQueueTest.class);
    }

    public TemporaryQueueTest(String name) {
        super(name);
    }
}

