/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.properties;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;

public class MessagePropertyTest
extends PTPTestCase {
    public void testSetObjectProperty_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setObjectProperty("prop", new Vector());
            Assert.fail((String)"sec. 3.5.5 An attempt to use any other class [than Boolean, Byte,...,String] must throw a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.MessageFormatException, not a " + String.valueOf((Object)e)));
        }
    }

    public void testSetObjectProperty_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setObjectProperty("pi", (Object)Float.valueOf(3.14159f));
            Assert.assertEquals((float)3.14159f, (float)message.getFloatProperty("pi"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetObjectProperty() {
        try {
            Message message = this.senderSession.createMessage();
            Assert.assertEquals((String)"sec. 3.5.5 A null value is returned [by the getObjectProperty method] if a property by the specified name does not exits.\n", null, (Object)message.getObjectProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetStringProperty() {
        try {
            Message message = this.senderSession.createMessage();
            Assert.assertEquals((String)"sec. 3.5.5 A null value is returned [by the getStringProperty method] if a property by the specified name does not exits.\n", null, (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetDoubleProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getDoubleProperty("prop");
            Assert.fail((String)"Should raise a NullPointerException.\n");
        }
        catch (NullPointerException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetFloatProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getFloatProperty("prop");
            Assert.fail((String)"Should raise a NullPointerException.\n");
        }
        catch (NullPointerException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetLongProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getLongProperty("prop");
            Assert.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetIntProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getIntProperty("prop");
            Assert.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetShortProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getShortProperty("prop");
            Assert.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetByteProperty() {
        try {
            Message message = this.senderSession.createMessage();
            message.getByteProperty("prop");
            Assert.fail((String)"Should raise a NumberFormatException.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetBooleanProperty() {
        try {
            Message message = this.senderSession.createMessage();
            Assert.assertEquals((Object)false, (Object)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testGetPropertyNames() {
        try {
            Message message = this.senderSession.createMessage();
            message.setJMSCorrelationID("foo");
            Enumeration enumeration = message.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                boolean valid = !propName.startsWith("JMS") || propName.startsWith("JMSX");
                Assert.assertTrue((String)("sec. 3.5.6 The getPropertyNames method does not return the names of the JMS standard header field [e.g. JMSCorrelationID]: " + propName), (boolean)valid);
            }
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testPropertyIteration() {
        try {
            Message message = this.senderSession.createMessage();
            Enumeration enumeration = message.getPropertyNames();
            int originalCount = 0;
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++originalCount;
            }
            message.setDoubleProperty("pi", 3.14159);
            enumeration = message.getPropertyNames();
            boolean foundPiProperty = false;
            int newCount = 0;
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                ++newCount;
                if (!"pi".equals(propName)) continue;
                foundPiProperty = true;
            }
            Assert.assertEquals((long)(originalCount + 1), (long)newCount);
            Assert.assertTrue((boolean)foundPiProperty);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testClearProperties_2() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("foo");
            message.clearProperties();
            Assert.assertEquals((String)"sec. 3.5.7 Clearing a message's  property entries does not clear the value of its body.\n", (Object)"foo", (Object)message.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testClearProperties_1() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("prop", "foo");
            message.clearProperties();
            Assert.assertEquals((String)"sec. 3.5.7 A message's properties are deleted by the clearProperties method.\n", null, (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(MessagePropertyTest.class);
    }

    public MessagePropertyTest(String name) {
        super(name);
    }
}

