/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.framework;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import javax.naming.Context;
import org.objectweb.jtests.jms.framework.JMSTestCase;

public abstract class UnifiedTestCase
extends JMSTestCase {
    protected Context ctx;
    private static final String CF_NAME = "testCF";
    private static final String TCF_NAME = "testTCF";
    private static final String QCF_NAME = "testQCF";
    private static final String DESTINATION_NAME = "testDestination";
    private static final String QUEUE_NAME = "testJoramQueue";
    private static final String TOPIC_NAME = "testJoramTopic";
    protected Destination producerDestination;
    protected MessageProducer producer;
    protected ConnectionFactory producerCF;
    protected Connection producerConnection;
    protected Session producerSession;
    protected Destination consumerDestination;
    protected MessageConsumer consumer;
    protected ConnectionFactory consumerCF;
    protected Connection consumerConnection;
    protected Session consumerSession;
    protected QueueConnectionFactory queueConnectionFactory;
    protected Queue queue;
    protected TopicConnectionFactory topicConnectionFactory;
    protected Topic topic;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.admin.createConnectionFactory(CF_NAME);
            this.admin.createQueueConnectionFactory(QCF_NAME);
            this.admin.createTopicConnectionFactory(TCF_NAME);
            this.admin.createQueue(DESTINATION_NAME);
            this.admin.createQueue(QUEUE_NAME);
            this.admin.createTopic(TOPIC_NAME);
            this.ctx = this.admin.createContext();
            this.producerCF = (ConnectionFactory)this.ctx.lookup(CF_NAME);
            this.producerDestination = (Destination)this.ctx.lookup(DESTINATION_NAME);
            this.producerConnection = this.producerCF.createConnection();
            this.producerSession = this.producerConnection.createSession(false, 1);
            this.producer = this.producerSession.createProducer(this.producerDestination);
            this.consumerCF = (ConnectionFactory)this.ctx.lookup(CF_NAME);
            this.consumerDestination = (Destination)this.ctx.lookup(DESTINATION_NAME);
            this.consumerConnection = this.consumerCF.createConnection();
            this.consumerSession = this.consumerConnection.createSession(false, 1);
            this.consumer = this.consumerSession.createConsumer(this.consumerDestination);
            this.queueConnectionFactory = (QueueConnectionFactory)this.ctx.lookup(QCF_NAME);
            this.queue = (Queue)this.ctx.lookup(QUEUE_NAME);
            this.topicConnectionFactory = (TopicConnectionFactory)this.ctx.lookup(TCF_NAME);
            this.topic = (Topic)this.ctx.lookup(TOPIC_NAME);
            this.producerConnection.start();
            this.consumerConnection.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.consumerConnection.close();
            this.producerConnection.close();
            this.admin.deleteConnectionFactory(CF_NAME);
            this.admin.deleteQueueConnectionFactory(QCF_NAME);
            this.admin.deleteTopicConnectionFactory(TCF_NAME);
            this.admin.deleteQueue(DESTINATION_NAME);
            this.admin.deleteQueue(QUEUE_NAME);
            this.admin.deleteTopic(TOPIC_NAME);
        }
        catch (Exception exception) {
        }
        finally {
            this.producerDestination = null;
            this.producer = null;
            this.producerCF = null;
            this.producerSession = null;
            this.producerConnection = null;
            this.consumerDestination = null;
            this.consumer = null;
            this.consumerCF = null;
            this.consumerSession = null;
            this.consumerConnection = null;
            this.queueConnectionFactory = null;
            this.queue = null;
            this.topicConnectionFactory = null;
            this.topic = null;
        }
        super.tearDown();
    }

    public UnifiedTestCase(String name) {
        super(name);
    }
}

