/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class SessionTest
extends PTPTestCase {
    public void testRecoverTransactedSession() {
        try {
            Assert.assertEquals((Object)false, (Object)this.senderSession.getTransacted());
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            Assert.assertEquals((Object)true, (Object)this.senderSession.getTransacted());
            this.senderSession.recover();
            Assert.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (java.lang.IllegalStateException e) {
            Assert.fail((String)"Should raise a jakarta.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            Assert.fail((String)("Should raise a jakarta.jms.IllegalStateException, not a " + String.valueOf(e)));
        }
    }

    public void testRollbackTransactedSession() {
        try {
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            this.sender = this.senderSession.createSender(this.senderQueue);
            Assert.assertEquals((Object)true, (Object)this.senderSession.getTransacted());
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testRollbackTransactedSession");
            this.sender.send((Message)message);
            this.senderSession.rollback();
            TextMessage m = (TextMessage)this.receiver.receiveNoWait();
            Assert.assertEquals(null, (Object)m);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testCommitTransactedSession() {
        try {
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            this.sender = this.senderSession.createSender(this.senderQueue);
            Assert.assertEquals((Object)true, (Object)this.senderSession.getTransacted());
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testCommitTransactedSession");
            this.sender.send((Message)message);
            TextMessage m = (TextMessage)this.receiver.receiveNoWait();
            Assert.assertEquals(null, (Object)m);
            this.senderSession.commit();
            m = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"testCommitTransactedSession", (Object)m.getText());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testRollbackNonTransactedSession() {
        try {
            Assert.assertEquals((Object)false, (Object)this.senderSession.getTransacted());
            this.senderSession.rollback();
            Assert.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (java.lang.IllegalStateException e) {
            Assert.fail((String)"Should raise a jakarta.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            Assert.fail((String)("Should raise a jakarta.jms.IllegalStateException, not a " + String.valueOf(e)));
        }
    }

    public void testCommitNonTransactedSession() {
        try {
            Assert.assertEquals((Object)false, (Object)this.senderSession.getTransacted());
            this.senderSession.commit();
            Assert.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (java.lang.IllegalStateException e) {
            Assert.fail((String)"Should raise a jakarta.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            Assert.fail((String)("Should raise a jakarta.jms.IllegalStateException, not a " + String.valueOf(e)));
        }
    }

    public void testGetTransacted() {
        try {
            Assert.assertEquals((Object)false, (Object)this.senderSession.getTransacted());
            this.senderSession = this.senderConnection.createQueueSession(true, 1);
            Assert.assertEquals((Object)true, (Object)this.senderSession.getTransacted());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testAcknowledge() {
        try {
            if (this.receiverSession != null) {
                this.receiverSession.close();
            }
            this.receiverSession = this.receiverConnection.createQueueSession(false, 2);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            this.receiverSession.close();
            m.acknowledge();
            Assert.fail((String)"sec. 4.4.1 Invoking the acknowledge method of a received message from a closed  session must throw an [jakarta.jms.]IllegalStateException.\n");
        }
        catch (IllegalStateException message) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should raise a jakarta.jms.IllegalStateException, not a " + String.valueOf((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            Assert.fail((String)"sec. 4.4.1 Invoking the acknowledge method of a received message from a closed session must throw an [jakarta.jms.]IllegalStateException, [not a java.lang.IllegalStateException]");
        }
    }

    public void testUseMessage() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testUseMessage");
            this.sender.send((Message)message);
            TextMessage m = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            this.receiverSession.close();
            Assert.assertEquals((Object)"testUseMessage", (Object)m.getText());
        }
        catch (Exception e) {
            Assert.fail((String)"sec. 4.4.1 It is valid to continue to use message objects created or received via the [closed] session.\n");
        }
    }

    public void testUsedClosedSession() {
        try {
            this.senderSession.close();
            this.senderSession.createMessage();
            Assert.fail((String)"sec. 4.4.1 An attempt to use [a closed session] must throw a [jakarta.jms.]IllegalStateException.\n");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should raise a jakarta.jms.IllegalStateException, not a " + String.valueOf((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            Assert.fail((String)"Should raise a jakarta.jms.IllegalStateException, not a java.lang.IllegalStateException");
        }
    }

    public void testCloseClosedSession() {
        try {
            this.senderSession.close();
            this.senderSession.close();
        }
        catch (Exception e) {
            Assert.fail((String)"sec. 4.4.1 Closing a closed session must NOT throw an exception.\n");
        }
    }

    public static Test suite() {
        return new TestSuite(SessionTest.class);
    }

    public SessionTest(String name) {
        super(name);
    }
}

