/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.selector;

import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class SelectorTest
extends PTPTestCase {
    public void testEmptyStringAsSelector() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "");
        TextMessage message = this.senderSession.createTextMessage();
        message.setText("testEmptyStringAsSelector");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testEmptyStringAsSelector", (Object)msg.getText());
    }

    public void testStringLiterals() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "string = 'literal''s'");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("string", "literal");
        dummyMessage.setText("testStringLiterals:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setStringProperty("string", "literal's");
        message.setText("testStringLiterals:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testStringLiterals:2", (Object)msg.getText());
    }

    public void testJMSDeliveryModeInSelector() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "JMSDeliveryMode = 'PERSISTENT'");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setText("testJMSDeliveryModeInSelector:1");
        this.sender.send((Message)dummyMessage, 1, this.sender.getPriority(), this.sender.getTimeToLive());
        TextMessage message = this.senderSession.createTextMessage();
        message.setText("testJMSDeliveryModeInSelector:2");
        this.sender.send((Message)message, 2, this.sender.getPriority(), this.sender.getTimeToLive());
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"No message was received", (msg != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)msg.getJMSDeliveryMode());
        Assert.assertEquals((Object)"testJMSDeliveryModeInSelector:2", (Object)msg.getText());
    }

    public void testIdentifierConversion() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "NumberOfOrders > 1");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("NumberOfOrders", "2");
        dummyMessage.setText("testIdentifierConversion:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setIntProperty("NumberOfOrders", 2);
        message.setText("testIdentifierConversion:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertEquals((Object)"testIdentifierConversion:2", (Object)msg.getText());
    }

    public void testSelectorExampleFromSpecs() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "JMSType = 'car' AND color = 'blue' AND weight > 2500");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setJMSType("car");
        dummyMessage.setStringProperty("color", "red");
        dummyMessage.setLongProperty("weight", 3000L);
        dummyMessage.setText("testSelectorExampleFromSpecs:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setJMSType("car");
        message.setStringProperty("color", "blue");
        message.setLongProperty("weight", 3000L);
        message.setText("testSelectorExampleFromSpecs:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertEquals((Object)"testSelectorExampleFromSpecs:2", (Object)msg.getText());
    }

    public void testGreaterThan() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight > 2500");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setLongProperty("weight", 1000L);
        dummyMessage.setText("testGreaterThan:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setLongProperty("weight", 3000L);
        message.setText("testGreaterThan:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertEquals((Object)"testGreaterThan:2", (Object)msg.getText());
    }

    public void testEquals() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight = 2500");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setLongProperty("weight", 1000L);
        dummyMessage.setText("testEquals:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setLongProperty("weight", 2500L);
        message.setText("testEquals:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertEquals((Object)"testEquals:2", (Object)msg.getText());
    }

    public void testNotEquals() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "weight <> 2500");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setLongProperty("weight", 2500L);
        dummyMessage.setText("testEquals:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setLongProperty("weight", 1000L);
        message.setText("testEquals:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertEquals((Object)"testEquals:2", (Object)msg.getText());
    }

    public void testBetween() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "age BETWEEN 15 and 19");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setIntProperty("age", 20);
        dummyMessage.setText("testBetween:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setIntProperty("age", 17);
        message.setText("testBetween:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testBetween"));
        Assert.assertEquals((Object)"testBetween:2", (Object)msg.getText());
    }

    public void testIn() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "Country IN ('UK', 'US', 'France')");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("Country", "Peru");
        dummyMessage.setText("testIn:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setStringProperty("Country", "UK");
        message.setText("testIn:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testIn"));
        Assert.assertEquals((Object)"testIn:2", (Object)msg.getText());
    }

    public void testLikeEscape() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "underscored LIKE '\\_%' ESCAPE '\\'");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("underscored", "bar");
        dummyMessage.setText("testLikeEscape:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setStringProperty("underscored", "_foo");
        message.setText("testLikeEscape:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLikeEscape"));
        Assert.assertEquals((Object)"testLikeEscape:2", (Object)msg.getText());
    }

    public void testLike_2() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "word LIKE 'l_se'");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("word", "loose");
        dummyMessage.setText("testLike_2:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setStringProperty("word", "lose");
        message.setText("testLike_2:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLike_2"));
        Assert.assertEquals((Object)"testLike_2:2", (Object)msg.getText());
    }

    public void testLike_1() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "phone LIKE '12%3'");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("phone", "1234");
        dummyMessage.setText("testLike_1:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setStringProperty("phone", "12993");
        message.setText("testLike_1:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((String)"Message not received", (msg != null ? 1 : 0) != 0);
        Assert.assertTrue((String)("Message of another test: " + msg.getText()), (boolean)msg.getText().startsWith("testLike_1"));
        Assert.assertEquals((Object)"testLike_1:2", (Object)msg.getText());
    }

    public void testNull() throws Exception {
        if (this.receiver != null) {
            this.receiver.close();
        }
        this.receiver = this.receiverSession.createReceiver(this.receiverQueue, "prop_name IS NULL");
        TextMessage dummyMessage = this.senderSession.createTextMessage();
        dummyMessage.setStringProperty("prop_name", "not null");
        dummyMessage.setText("testNull:1");
        this.sender.send((Message)dummyMessage);
        TextMessage message = this.senderSession.createTextMessage();
        message.setText("testNull:2");
        this.sender.send((Message)message);
        TextMessage msg = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
        Assert.assertTrue((msg != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"testNull:2", (Object)msg.getText());
    }

    public static Test suite() {
        return new TestSuite(SelectorTest.class);
    }

    public SelectorTest(String name) {
        super(name);
    }
}

