/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.headers;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TemporaryQueue;
import javax.naming.Context;
import javax.naming.NamingException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class MessageHeaderTest
extends PTPTestCase {
    public void testJMSPriority_2() {
        try {
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            this.sender.setPriority(9);
            this.sender.send(message);
            Assert.assertEquals((String)"sec. 3.4.9 After completion of the send it holds the value specified by the method sending the message.\n", (long)9L, (long)message.getJMSPriority());
            this.receiver.receive(TestConfig.TIMEOUT);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSPriority_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setJMSPriority(0);
            this.sender.send(message);
            Assert.assertTrue((String)"sec. 3.4.9 When a message is sent this value is ignored.\n", (message.getJMSPriority() != 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"sec. 3.4.9 After completion of the send it holds the value specified by the method sending the message.\n", (long)4L, (long)message.getJMSPriority());
            this.receiver.receive(TestConfig.TIMEOUT);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSExpiration() {
        try {
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertEquals((String)"sec. 3.4.9 When a message is received its JMSExpiration header field contains this same value [i.e. set on return of the send method].\n", (long)message.getJMSExpiration(), (long)msg.getJMSExpiration());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSMessageID_2() {
        try {
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            Assert.assertTrue((String)"sec. 3.4.3 When the send method returns it contains a provider-assigned value.\n", (message.getJMSMessageID() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"sec. 3.4.3 All JMSMessageID values must start with the prefix 'ID:'.\n", (boolean)message.getJMSMessageID().startsWith("ID:"));
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((String)"sec. 3.4.3 All JMSMessageID values must start with the prefix 'ID:'.\n", (boolean)msg.getJMSMessageID().startsWith("ID:"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSMessageID_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setJMSMessageID("ID:foo");
            this.sender.send(message);
            Assert.assertTrue((String)"sec. 3.4.3 When a message is sent this value is ignored.\n", (message.getJMSMessageID() != "ID:foo" ? 1 : 0) != 0);
            this.receiver.receive(TestConfig.TIMEOUT);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSDeliveryMode() {
        try {
            Assert.assertEquals((long)2L, (long)this.sender.getDeliveryMode());
            Message message = this.senderSession.createMessage();
            message.setJMSDeliveryMode(1);
            this.sender.send(message);
            Assert.assertTrue((String)"sec. 3.4.2 When a message is sent this value is ignored", (message.getJMSDeliveryMode() != 1 ? 1 : 0) != 0);
            Assert.assertEquals((String)"sec. 3.4.2 After completion of the send it holds the delivery mode specified by the sending method (persistent by default).\n", (long)2L, (long)message.getJMSDeliveryMode());
            this.receiver.receive(TestConfig.TIMEOUT);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSDestination() {
        try {
            this.admin.createQueue("anotherQueue");
            Context ctx = this.admin.createContext();
            Queue anotherQueue = (Queue)ctx.lookup("anotherQueue");
            Assert.assertTrue((anotherQueue != this.senderQueue ? 1 : 0) != 0);
            Message message = this.senderSession.createMessage();
            message.setJMSDestination((Destination)anotherQueue);
            this.sender.send(message);
            Assert.assertTrue((String)"sec. 3.4.1 When a message is sent this value is ignored.\n", (message.getJMSDestination() != anotherQueue ? 1 : 0) != 0);
            Assert.assertEquals((String)"sec. 3.4.1 After completion of the send it holds the destination object specified by the sending method.\n", (Object)this.senderQueue, (Object)message.getJMSDestination());
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertEquals((String)"sec. 3.4.1 When a message is received, its destination value must be equivalent   to the value assigned when it was sent.\n", (Object)((Queue)message.getJMSDestination()).getQueueName(), (Object)((Queue)msg.getJMSDestination()).getQueueName());
            this.admin.deleteQueue("anotherQueue");
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
        catch (NamingException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testJMSReplyTo_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setJMSReplyTo((Destination)this.senderQueue);
            this.sender.send(message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Destination dest = msg.getJMSReplyTo();
            Assert.assertTrue((String)"JMS ReplyTo header field should be a Queue", (boolean)(dest instanceof Queue));
            Queue replyTo = (Queue)dest;
            Assert.assertEquals((String)"JMS ReplyTo header field should be equals to the sender queue", (Object)replyTo.getQueueName(), (Object)this.senderQueue.getQueueName());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSReplyTo_2() {
        try {
            TemporaryQueue tempQueue = this.senderSession.createTemporaryQueue();
            Message message = this.senderSession.createMessage();
            message.setJMSReplyTo((Destination)tempQueue);
            this.sender.send(message);
            Message msg = this.receiver.receive(TestConfig.TIMEOUT);
            Destination dest = msg.getJMSReplyTo();
            Assert.assertTrue((String)"JMS ReplyTo header field should be a TemporaryQueue", (boolean)(dest instanceof TemporaryQueue));
            Queue replyTo = (Queue)dest;
            Assert.assertEquals((String)"JMS ReplyTo header field should be equals to the temporary queue", (Object)replyTo.getQueueName(), (Object)tempQueue.getQueueName());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(MessageHeaderTest.class);
    }

    public MessageHeaderTest(String name) {
        super(name);
    }
}

