/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.artemiswrapper.ArtemisBrokerWrapper;
import org.apache.activemq.broker.artemiswrapper.RegionProxy;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.usage.Usage;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RegionBrokerProxy
implements Broker {
    private final ActiveMQServer server;
    private final MBeanServer mBeanServer;

    private RegionBrokerProxy(ArtemisBrokerWrapper wrapper) {
        this.server = wrapper.getServer();
        this.mBeanServer = wrapper.getMbeanServer();
    }

    public static RegionBroker newRegionBroker(ArtemisBrokerWrapper broker) {
        RegionBrokerProxy brokerProxy = null;
        try {
            brokerProxy = new RegionBrokerProxy(broker);
            RegionBroker regionBroker = (RegionBroker)Mockito.mock(RegionBroker.class, (Answer)AdditionalAnswers.delegatesTo((Object)brokerProxy));
            return regionBroker;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Region getTopicRegion() {
        return RegionProxy.newTopicRegion(this.server);
    }

    public Region getQueueRegion() {
        return RegionProxy.newQueueRegion(this.server);
    }

    public Broker getAdaptor(Class aClass) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BrokerId getBrokerId() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getBrokerName() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addBroker(Connection connection, BrokerInfo brokerInfo) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeBroker(Connection connection, BrokerInfo brokerInfo) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addConnection(ConnectionContext connectionContext, ConnectionInfo connectionInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeConnection(ConnectionContext connectionContext, ConnectionInfo connectionInfo, Throwable throwable) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addSession(ConnectionContext connectionContext, SessionInfo sessionInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeSession(ConnectionContext connectionContext, SessionInfo sessionInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Destination addDestination(ConnectionContext connectionContext, ActiveMQDestination activeMQDestination, boolean b) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeDestination(ConnectionContext connectionContext, ActiveMQDestination activeMQDestination, long l) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Subscription addConsumer(ConnectionContext connectionContext, ConsumerInfo consumerInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeConsumer(ConnectionContext connectionContext, ConsumerInfo consumerInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addProducer(ConnectionContext connectionContext, ProducerInfo producerInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeProducer(ConnectionContext connectionContext, ProducerInfo producerInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeSubscription(ConnectionContext connectionContext, RemoveSubscriptionInfo removeSubscriptionInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void send(ProducerBrokerExchange producerBrokerExchange, Message message) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void acknowledge(ConsumerBrokerExchange consumerBrokerExchange, MessageAck messageAck) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Response messagePull(ConnectionContext connectionContext, MessagePull messagePull) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void gc() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Set<Destination> getDestinations(ActiveMQDestination activeMQDestination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void processConsumerControl(ConsumerBrokerExchange consumerBrokerExchange, ConsumerControl consumerControl) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void reapplyInterceptor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Connection[] getClients() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ActiveMQDestination[] getDestinations() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Map<ActiveMQDestination, Destination> getDestinationMap(ActiveMQDestination activeMQDestination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public TransactionId[] getPreparedTransactions(ConnectionContext connectionContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void beginTransaction(ConnectionContext connectionContext, TransactionId transactionId) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int prepareTransaction(ConnectionContext connectionContext, TransactionId transactionId) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void rollbackTransaction(ConnectionContext connectionContext, TransactionId transactionId) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void commitTransaction(ConnectionContext connectionContext, TransactionId transactionId, boolean b) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void forgetTransaction(ConnectionContext connectionContext, TransactionId transactionId) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BrokerInfo[] getPeerBrokerInfos() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void postProcessDispatch(MessageDispatch messageDispatch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isStopped() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Set<ActiveMQDestination> getDurableDestinations() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addDestinationInfo(ConnectionContext connectionContext, DestinationInfo destinationInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeDestinationInfo(ConnectionContext connectionContext, DestinationInfo destinationInfo) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isFaultTolerantConfiguration() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ConnectionContext getAdminConnectionContext() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setAdminConnectionContext(ConnectionContext connectionContext) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PListStore getTempDataStore() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public URI getVmConnectorURI() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void brokerServiceStarted() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BrokerService getBrokerService() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Broker getRoot() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isExpired(MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageExpired(ConnectionContext connectionContext, MessageReference messageReference, Subscription subscription) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean sendToDeadLetterQueue(ConnectionContext connectionContext, MessageReference messageReference, Subscription subscription, Throwable throwable) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long getBrokerSequenceId() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageConsumed(ConnectionContext connectionContext, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageDelivered(ConnectionContext connectionContext, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void messageDiscarded(ConnectionContext connectionContext, Subscription subscription, MessageReference messageReference) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void slowConsumer(ConnectionContext connectionContext, Destination destination, Subscription subscription) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void fastProducer(ConnectionContext connectionContext, ProducerInfo producerInfo, ActiveMQDestination activeMQDestination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void isFull(ConnectionContext connectionContext, Destination destination, Usage usage) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void virtualDestinationAdded(ConnectionContext connectionContext, VirtualDestination virtualDestination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void virtualDestinationRemoved(ConnectionContext connectionContext, VirtualDestination virtualDestination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void nowMasterBroker() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ThreadPoolExecutor getExecutor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void networkBridgeStarted(BrokerInfo brokerInfo, boolean b, String s) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void networkBridgeStopped(BrokerInfo brokerInfo) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void start() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void stop() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

