/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.artemiswrapper;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.policy.DestinationProxy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RegionProxy
implements Region {
    private final ActiveMQServer server;
    private final RoutingType routingType;

    private RegionProxy(ActiveMQServer activeMQServer, RoutingType routingType) {
        this.server = activeMQServer;
        this.routingType = routingType;
    }

    public static Region newQueueRegion(ActiveMQServer activeMQServer) {
        return (Region)Mockito.mock(QueueRegion.class, (Answer)AdditionalAnswers.delegatesTo((Object)new RegionProxy(activeMQServer, RoutingType.ANYCAST)));
    }

    public static Region newTopicRegion(ActiveMQServer activeMQServer) {
        return (Region)Mockito.mock(TopicRegion.class, (Answer)AdditionalAnswers.delegatesTo((Object)new RegionProxy(activeMQServer, RoutingType.MULTICAST)));
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        return this.server.getPostOffice().getAllBindings().entrySet().stream().filter(e -> e.getValue() instanceof QueueBinding).filter(e -> {
            SimpleString address = ((QueueBinding)e.getValue()).getQueue().getAddress();
            return this.server.getAddressInfo(address).getRoutingType() == this.routingType;
        }).collect(Collectors.toMap(e -> {
            String uniqueName = ((Binding)e.getValue()).getUniqueName().toString();
            return new ActiveMQQueue(uniqueName);
        }, e -> {
            Queue queue = ((QueueBinding)e.getValue()).getQueue();
            String address = ((Binding)e.getValue()).getAddress().toString();
            return new DestinationProxy(queue, address, this.server);
        }));
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void gc() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Set<Destination> getDestinations(ActiveMQDestination destination) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void reapplyInterceptor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void start() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void stop() throws Exception {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

