/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.artemiswrapper;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.artemiswrapper.ArtemisBrokerBase;
import org.apache.activemq.broker.artemiswrapper.InVMNamingContext;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.command.ActiveMQDestination;

public class ArtemisBrokerWrapper
extends ArtemisBrokerBase {
    protected final Map<String, SimpleString> testQueues = new HashMap<String, SimpleString>();
    protected JMSServerManagerImpl jmsServer;
    protected MBeanServer mbeanServer;

    public ArtemisBrokerWrapper(BrokerService brokerService, File temporaryFolder) {
        super(temporaryFolder);
        this.bservice = brokerService;
    }

    public void start() throws Exception {
        String match;
        AddressSettings commonSettings;
        this.clearDataRecreateServerDirs();
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
        this.server = this.createServer(this.realStore, true);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.getConfiguration().getAcceptorConfigurations().clear();
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.setJMXManagementEnabled(true);
        Map addressSettingsMap = serverConfig.getAddressesSettings();
        PolicyMap policyMap = this.bservice.getDestinationPolicy();
        if (policyMap != null) {
            this.translatePolicyMap(serverConfig, policyMap);
        }
        if ((commonSettings = (AddressSettings)addressSettingsMap.get(match = "#")) == null) {
            commonSettings = new AddressSettings();
            addressSettingsMap.put(match, commonSettings);
        }
        SimpleString dla = new SimpleString("ActiveMQ.DLQ");
        commonSettings.setDeadLetterAddress(dla);
        commonSettings.setExpiryAddress(dla);
        commonSettings.setAutoCreateQueues(Boolean.valueOf(true));
        commonSettings.setAutoCreateAddresses(Boolean.valueOf(true));
        if (this.bservice.extraConnectors.size() == 0) {
            serverConfig.addAcceptorConfiguration("home", "tcp://localhost:61616");
        }
        for (BrokerService.ConnectorInfo info : this.bservice.extraConnectors) {
            this.addServerAcceptor(serverConfig, info);
        }
        serverConfig.setSecurityEnabled(this.enableSecurity);
        if (this.enableSecurity) {
            HashSet<Role> anySet;
            ActiveMQJAASSecurityManager sm = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
            SecurityConfiguration securityConfig = sm.getConfiguration();
            securityConfig.addRole("openwireSender", "sender");
            securityConfig.addUser("openwireSender", "SeNdEr");
            Role senderRole = new Role("sender", true, false, false, false, true, true, false, false);
            securityConfig.addRole("openwireReceiver", "receiver");
            securityConfig.addUser("openwireReceiver", "ReCeIvEr");
            Role receiverRole = new Role("receiver", false, true, false, false, true, true, false, true);
            securityConfig.addRole("openwireGuest", "guest");
            securityConfig.addUser("openwireGuest", "GuEsT");
            Role guestRole = new Role("guest", false, false, false, false, false, false, false, false);
            securityConfig.addRole("openwireDestinationManager", "manager");
            securityConfig.addUser("openwireDestinationManager", "DeStInAtIoN");
            Role destRole = new Role("manager", false, false, false, false, true, true, false, false);
            HashMap<String, HashSet<Role>> settings = this.server.getConfiguration().getSecurityRoles();
            if (settings == null) {
                settings = new HashMap<String, HashSet<Role>>();
                this.server.getConfiguration().setSecurityRoles(settings);
            }
            if ((anySet = (HashSet<Role>)settings.get("#")) == null) {
                anySet = new HashSet<Role>();
                settings.put("#", anySet);
            }
            anySet.add(senderRole);
            anySet.add(receiverRole);
            anySet.add(guestRole);
            anySet.add(destRole);
        }
        Set acceptors = serverConfig.getAcceptorConfigurations();
        Iterator iter = acceptors.iterator();
        while (iter.hasNext()) {
            System.out.println("acceptor =>: " + iter.next());
        }
        this.jmsServer = new JMSServerManagerImpl(this.server);
        InVMNamingContext namingContext = new InVMNamingContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)namingContext));
        this.jmsServer.start();
        this.server.start();
        this.stopped = false;
    }

    public void virtualDestinationAdded(ConnectionContext connectionContext, VirtualDestination virtualDestination) {
    }

    public void virtualDestinationRemoved(ConnectionContext connectionContext, VirtualDestination virtualDestination) {
    }

    private void addServerAcceptor(Configuration serverConfig, BrokerService.ConnectorInfo info) throws Exception {
        serverConfig.addAcceptorConfiguration("homePort" + info.uri.getPort(), info.uri.toString());
    }

    private void translatePolicyMap(Configuration serverConfig, PolicyMap policyMap) {
        List allEntries = policyMap.getAllEntries();
        Map settingsMap = serverConfig.getAddressesSettings();
        for (Object o : allEntries) {
            PolicyEntry entry = (PolicyEntry)o;
            ActiveMQDestination targetDest = entry.getDestination();
            String match = this.getCorePattern(targetDest);
            AddressSettings settings = (AddressSettings)settingsMap.get(match);
            if (settings == null) {
                settings = new AddressSettings();
                settingsMap.put(match, settings);
            }
            if (entry.isAdvisoryForSlowConsumers()) {
                settings.setSlowConsumerThreshold(1000L);
                settings.setSlowConsumerCheckPeriod(1L);
                settings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
            }
            if (entry.isProducerFlowControl()) {
                settings.setMaxSizeBytes(10240000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
                if (this.bservice.getSystemUsage().isSendFailIfNoSpace()) {
                    settings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
                }
            }
            int queuePrefetch = entry.getQueuePrefetch();
            settings.setQueuePrefetch(queuePrefetch);
        }
        PolicyEntry defaultEntry = policyMap.getDefaultEntry();
        if (defaultEntry != null) {
            AddressSettings defSettings = (AddressSettings)settingsMap.get("#");
            if (defSettings == null) {
                defSettings = new AddressSettings();
                settingsMap.put("#", defSettings);
            }
            if (defaultEntry.isProducerFlowControl()) {
                defSettings.setMaxSizeBytes(10240000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
                if (this.bservice.getSystemUsage().isSendFailIfNoSpace()) {
                    defSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
                }
            }
        }
    }

    private String getCorePattern(ActiveMQDestination dest) {
        String physicalName = dest.getPhysicalName();
        String pattern = physicalName.replace(">", "#");
        return pattern;
    }

    public void stop() throws Exception {
        try {
            this.server.stop();
            this.testQueues.clear();
            this.stopped = true;
        }
        catch (Throwable throwable) {
        }
        finally {
            this.server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeSureQueueExists(String qname) throws Exception {
        Map<String, SimpleString> map = this.testQueues;
        synchronized (map) {
            SimpleString coreQ = this.testQueues.get(qname);
            if (coreQ == null) {
                coreQ = new SimpleString(qname);
                try {
                    this.server.createQueue(coreQ, RoutingType.MULTICAST, coreQ, null, false, false);
                    this.testQueues.put(qname, coreQ);
                }
                catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                    // empty catch block
                }
            }
        }
    }

    public long getAMQueueMessageCount(ActiveMQDestination amq5Dest) {
        if (amq5Dest.isTopic()) {
            throw new IllegalArgumentException("Method only accept queue type parameter.");
        }
        long count = 0L;
        String qname = null;
        qname = amq5Dest.isTemporary() ? amq5Dest.getPhysicalName() : amq5Dest.getPhysicalName();
        Binding binding = this.server.getPostOffice().getBinding(new SimpleString(qname));
        if (binding != null) {
            QueueImpl q = (QueueImpl)binding.getBindable();
            count = q.getMessageCount();
        }
        return count;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }
}

