/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemiswrapper;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisBrokerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisBrokerHelper.class);
    private static volatile Object service = null;
    private static Class<?> serviceClass;

    public static void startArtemisBroker(URI location) throws IOException {
        LOG.info("---starting broker, service is there? " + service);
        if (service != null) {
            return;
        }
        try {
            service = serviceClass.newInstance();
            Method startMethod = serviceClass.getMethod("start", new Class[0]);
            startMethod.invoke(service, (Object[])null);
            LOG.info("started a service instance: " + service);
        }
        catch (InstantiationException e) {
            throw new IOException("Inst exception", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("IllegalAccess exception ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Nosuchmethod", e);
        }
        catch (SecurityException e) {
            throw new IOException("Security exception", e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("IllegalArgumentException exception", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("InvocationTargetException exception", e);
        }
    }

    public static void makeSureDestinationExists(ActiveMQDestination activemqDestination) throws Exception {
        Method startMethod = serviceClass.getMethod("makeSureDestinationExists", ActiveMQDestination.class);
        startMethod.invoke(service, activemqDestination);
    }

    public static BrokerService getBroker() {
        return (BrokerService)service;
    }

    public static void stopArtemisBroker() {
        try {
            if (service != null) {
                Method startMethod = serviceClass.getMethod("stop", new Class[0]);
                startMethod.invoke(service, (Object[])null);
                System.out.println("stopped the service instance: " + service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            service = null;
        }
    }

    static {
        try {
            serviceClass = Class.forName("org.apache.activemq.broker.BrokerService");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

