/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.artemiswrapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;
import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.apache.activemq.artemis.utils.uri.URISupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.artemiswrapper.CleanupThreadRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class OpenwireArtemisBaseTest {
    @Rule
    public CleanupThreadRule cleanupRules = new CleanupThreadRule();
    @Rule
    public ThreadLeakCheckRule leakCheckRule = new ThreadLeakCheckRule();
    @Rule
    public TemporaryFolder temporaryFolder;
    @Rule
    public TestName name = new TestName();
    public String CLUSTER_PASSWORD = "OPENWIRECLUSTER";

    public OpenwireArtemisBaseTest() {
        File tmpRoot = new File("./target/tmp");
        tmpRoot.mkdirs();
        this.temporaryFolder = new TemporaryFolder(tmpRoot);
        BrokerService.disableWrapper = true;
    }

    public String getTmp() {
        return this.getTmpFile().getAbsolutePath();
    }

    public File getTmpFile() {
        return this.temporaryFolder.getRoot();
    }

    protected String getJournalDir(int serverID, boolean backup) {
        return this.getTmp() + "/journal_" + serverID + "_" + backup;
    }

    protected String getBindingsDir(int serverID, boolean backup) {
        return this.getTmp() + "/binding_" + serverID + "_" + backup;
    }

    protected String getPageDir(int serverID, boolean backup) {
        return this.getTmp() + "/paging_" + serverID + "_" + backup;
    }

    protected String getLargeMessagesDir(int serverID, boolean backup) {
        return this.getTmp() + "/paging_" + serverID + "_" + backup;
    }

    protected Configuration createConfig(int serverID) throws Exception {
        return this.createConfig("localhost", serverID, Collections.EMPTY_MAP);
    }

    protected Configuration createConfig(String hostAddress, int serverID, int port) throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl().setJMXManagementEnabled(false).setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(1024000).setJournalType(JournalType.NIO).setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false)).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword(this.CLUSTER_PASSWORD);
        configuration.addAddressesSetting("#", new AddressSettings().setAutoCreateJmsQueues(true).setAutoDeleteJmsQueues(true));
        configuration.addAcceptorConfiguration("netty", OpenwireArtemisBaseTest.newURIwithPort(hostAddress, port));
        configuration.addConnectorConfiguration("netty-connector", OpenwireArtemisBaseTest.newURIwithPort(hostAddress, port));
        return configuration;
    }

    protected Configuration createConfig(String hostAddress, int serverID) throws Exception {
        return this.createConfig(hostAddress, serverID, Collections.EMPTY_MAP);
    }

    protected Configuration createConfig(String hostAddress, int serverID, Map<String, String> params) throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl().setJMXManagementEnabled(false).setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(1024000).setJournalType(JournalType.NIO).setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false)).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword(this.CLUSTER_PASSWORD);
        configuration.addAddressesSetting("#", new AddressSettings().setAutoCreateJmsQueues(true).setAutoDeleteJmsQueues(true));
        configuration.addAcceptorConfiguration("netty", OpenwireArtemisBaseTest.newURI(hostAddress, serverID) + "?" + URISupport.createQueryString(params));
        configuration.addConnectorConfiguration("netty-connector", OpenwireArtemisBaseTest.newURI(hostAddress, serverID));
        return configuration;
    }

    protected Configuration createConfig(int serverID, String extraAcceptorParams) throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl().setJMXManagementEnabled(false).setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(JournalType.NIO).setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false)).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword(this.CLUSTER_PASSWORD);
        configuration.addAddressesSetting("#", new AddressSettings().setAutoCreateJmsQueues(true).setAutoDeleteJmsQueues(true));
        String fullAcceptorUri = OpenwireArtemisBaseTest.newURI(serverID) + extraAcceptorParams;
        configuration.addAcceptorConfiguration("netty", fullAcceptorUri);
        configuration.addConnectorConfiguration("netty-connector", OpenwireArtemisBaseTest.newURI(serverID));
        return configuration;
    }

    public void deployClusterConfiguration(Configuration config, Integer ... targetIDs) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        String separator = "";
        Integer[] integerArray = targetIDs;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int x = integerArray[i];
            stringBuffer.append(separator + OpenwireArtemisBaseTest.newURI(x));
            separator = ",";
        }
        String ccURI = "static://(" + stringBuffer.toString() + ")?connectorName=netty-connector;retryInterval=500;messageLoadBalancingType=STRICT;maxHops=1";
        config.addClusterConfiguration("clusterCC", ccURI);
    }

    protected static String newURI(int serverID) {
        return OpenwireArtemisBaseTest.newURI("localhost", serverID);
    }

    protected static String newURI(String localhostAddress, int serverID) {
        return "tcp://" + localhostAddress + ":" + (61616 + serverID);
    }

    protected static String newURIwithPort(String localhostAddress, int port) throws Exception {
        return OpenwireArtemisBaseTest.newURIwithPort(localhostAddress, port, Collections.EMPTY_MAP);
    }

    protected static String newURIwithPort(String localhostAddress, int port, Map<String, String> params) throws Exception {
        return "tcp://" + localhostAddress + ":" + port + "?" + URISupport.createQueryString(params);
    }

    public static JMSServerControl createJMSServerControl(MBeanServer mbeanServer) throws Exception {
        return (JMSServerControl)OpenwireArtemisBaseTest.createProxy(ObjectNameBuilder.DEFAULT.getJMSServerObjectName(), JMSServerControl.class, mbeanServer);
    }

    public static JMSQueueControl createJMSQueueControl(String name, MBeanServer mbeanServer) throws Exception {
        return (JMSQueueControl)OpenwireArtemisBaseTest.createProxy(ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(name), JMSQueueControl.class, mbeanServer);
    }

    private static Object createProxy(ObjectName objectName, Class mbeanInterface, MBeanServer mbeanServer) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, mbeanInterface, false);
    }

    protected void shutDownClusterServers(EmbeddedJMS[] servers) throws Exception {
        for (int i = 0; i < servers.length; ++i) {
            try {
                servers[i].stop();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void shutDownNonClusterServers(EmbeddedJMS[] servers) throws Exception {
        this.shutDownClusterServers(servers);
    }

    protected void setUpNonClusterServers(EmbeddedJMS[] servers) throws Exception {
        int i;
        Configuration[] serverCfgs = new Configuration[servers.length];
        for (i = 0; i < servers.length; ++i) {
            serverCfgs[i] = this.createConfig(i);
        }
        for (i = 0; i < servers.length; ++i) {
            servers[i] = new EmbeddedJMS().setConfiguration(serverCfgs[i]).setJmsConfiguration((JMSConfiguration)new JMSConfigurationImpl());
        }
        for (i = 0; i < servers.length; ++i) {
            servers[i].start();
        }
    }

    protected void setUpClusterServers(EmbeddedJMS[] servers) throws Exception {
        int i;
        Configuration[] serverCfgs = new Configuration[servers.length];
        for (i = 0; i < servers.length; ++i) {
            serverCfgs[i] = this.createConfig(i);
        }
        for (i = 0; i < servers.length; ++i) {
            this.deployClusterConfiguration(serverCfgs[i], this.getTargets(servers.length, i));
        }
        for (i = 0; i < servers.length; ++i) {
            servers[i] = new EmbeddedJMS().setConfiguration(serverCfgs[i]).setJmsConfiguration((JMSConfiguration)new JMSConfigurationImpl());
        }
        for (i = 0; i < servers.length; ++i) {
            servers[i].start();
        }
        for (i = 0; i < servers.length; ++i) {
            Assert.assertTrue((boolean)servers[i].waitClusterForming(100L, TimeUnit.MILLISECONDS, 20, servers.length));
        }
    }

    private Integer[] getTargets(int total, int self) {
        int lenTargets = total - self;
        ArrayList<Integer> targets = new ArrayList<Integer>();
        for (int i = 0; i < lenTargets; ++i) {
            if (i == self) continue;
            targets.add(i);
        }
        return targets.toArray(new Integer[0]);
    }

    public EmbeddedJMS createBroker() throws Exception {
        Configuration config0 = this.createConfig(0);
        EmbeddedJMS newbroker = new EmbeddedJMS().setConfiguration(config0).setJmsConfiguration((JMSConfiguration)new JMSConfigurationImpl());
        return newbroker;
    }
}

