/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.artemiswrapper;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.usage.Usage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArtemisBrokerBase
implements Broker {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisBrokerBase.class);
    public static final String INVM_ACCEPTOR_FACTORY = InVMAcceptorFactory.class.getCanonicalName();
    public static final String NETTY_ACCEPTOR_FACTORY = NettyAcceptorFactory.class.getCanonicalName();
    public static final String NETTY_CONNECTOR_FACTORY = NettyConnectorFactory.class.getCanonicalName();
    protected static final String CLUSTER_PASSWORD = "UnitTestsClusterPassword";
    protected volatile boolean stopped;
    protected BrokerId brokerId = new BrokerId("Artemis Broker");
    protected BrokerService bservice;
    protected final File temporaryFolder;
    protected final String testDir;
    protected boolean realStore = false;
    protected ActiveMQServer server;
    protected boolean enableSecurity = false;

    public ArtemisBrokerBase(File temporaryFolder) {
        this.temporaryFolder = temporaryFolder;
        this.testDir = temporaryFolder.getAbsolutePath();
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        throw new RuntimeException("Don't call me!");
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void gc() {
        throw new RuntimeException("Don't call me!");
    }

    public Set<Destination> getDestinations(ActiveMQDestination destination) {
        throw new RuntimeException("Don't call me!");
    }

    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        throw new RuntimeException("Don't call me!");
    }

    public void reapplyInterceptor() {
        throw new RuntimeException("Don't call me!");
    }

    public Broker getAdaptor(Class type) {
        throw new RuntimeException("Don't call me!");
    }

    public BrokerId getBrokerId() {
        return this.brokerId;
    }

    public String getBrokerName() {
        return "Artemis Broker";
    }

    public void addBroker(Connection connection, BrokerInfo info) {
        throw new RuntimeException("Don't call me!");
    }

    public void removeBroker(Connection connection, BrokerInfo info) {
        throw new RuntimeException("Don't call me!");
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public Connection[] getClients() throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public ActiveMQDestination[] getDestinations() throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public Map<ActiveMQDestination, Destination> getDestinationMap(ActiveMQDestination destination) {
        throw new RuntimeException("Don't call me!");
    }

    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public BrokerInfo[] getPeerBrokerInfos() {
        return null;
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
        throw new RuntimeException("Don't call me!");
    }

    public void postProcessDispatch(MessageDispatch messageDispatch) {
        throw new RuntimeException("Don't call me!");
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Set<ActiveMQDestination> getDurableDestinations() {
        throw new RuntimeException("Don't call me!");
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        throw new RuntimeException("Don't call me!");
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    public ConnectionContext getAdminConnectionContext() {
        return null;
    }

    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
    }

    public PListStore getTempDataStore() {
        throw new RuntimeException("Don't call me!");
    }

    public URI getVmConnectorURI() {
        throw new RuntimeException("Don't call me!");
    }

    public void brokerServiceStarted() {
        this.stopped = false;
    }

    public BrokerService getBrokerService() {
        return this.bservice;
    }

    public Broker getRoot() {
        return this;
    }

    public boolean isExpired(MessageReference messageReference) {
        throw new RuntimeException("Don't call me!");
    }

    public void messageExpired(ConnectionContext context, MessageReference messageReference, Subscription subscription) {
        throw new RuntimeException("Don't call me!");
    }

    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        throw new RuntimeException("Don't call me!");
    }

    public long getBrokerSequenceId() {
        throw new RuntimeException("Don't call me!");
    }

    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        throw new RuntimeException("Don't call me!");
    }

    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        throw new RuntimeException("Don't call me!");
    }

    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        throw new RuntimeException("Don't call me!");
    }

    public void slowConsumer(ConnectionContext context, Destination destination, Subscription subs) {
        throw new RuntimeException("Don't call me!");
    }

    public void fastProducer(ConnectionContext context, ProducerInfo producerInfo, ActiveMQDestination destination) {
        throw new RuntimeException("Don't call me!");
    }

    public void isFull(ConnectionContext context, Destination destination, Usage usage) {
        throw new RuntimeException("Don't call me!");
    }

    public void nowMasterBroker() {
    }

    public Scheduler getScheduler() {
        throw new RuntimeException("Don't call me!");
    }

    public ThreadPoolExecutor getExecutor() {
        throw new RuntimeException("Don't call me!");
    }

    public void networkBridgeStarted(BrokerInfo brokerInfo, boolean createdByDuplex, String remoteIp) {
        throw new RuntimeException("Don't call me!");
    }

    public void networkBridgeStopped(BrokerInfo brokerInfo) {
        throw new RuntimeException("Don't call me!");
    }

    protected final ActiveMQServer createServer(boolean realFiles, boolean netty) throws Exception {
        return this.createServer(realFiles, this.createDefaultConfig(netty), -1, -1, new HashMap<String, AddressSettings>());
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, Map<String, AddressSettings> settings) {
        return this.createServer(realFiles, configuration, pageSize, maxAddressSize, AddressFullMessagePolicy.PAGE, settings);
    }

    protected final ActiveMQServer createServer(boolean realFiles, Configuration configuration, int pageSize, int maxAddressSize, AddressFullMessagePolicy fullPolicy, Map<String, AddressSettings> settings) {
        ActiveMQServer server = ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)realFiles);
        if (settings != null) {
            for (Map.Entry<String, AddressSettings> setting : settings.entrySet()) {
                server.getAddressSettingsRepository().addMatch(setting.getKey(), (Object)setting.getValue());
            }
        }
        AddressSettings defaultSetting = new AddressSettings();
        defaultSetting.setPageSizeBytes((long)pageSize);
        defaultSetting.setMaxSizeBytes((long)maxAddressSize);
        defaultSetting.setAddressFullMessagePolicy(fullPolicy);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }

    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        if (netty) {
            return this.createDefaultConfig(new HashMap<String, Object>(), NETTY_ACCEPTOR_FACTORY);
        }
        return this.createDefaultConfig(new HashMap<String, Object>(), INVM_ACCEPTOR_FACTORY);
    }

    protected Configuration createDefaultConfig(Map<String, Object> params, String ... acceptors) throws Exception {
        ConfigurationImpl configuration = this.createBasicConfig(-1).setJMXManagementEnabled(false).clearAcceptorConfigurations();
        for (String acceptor : acceptors) {
            TransportConfiguration transportConfig = new TransportConfiguration(acceptor, params);
            configuration.addAcceptorConfiguration(transportConfig);
        }
        return configuration;
    }

    protected final ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = new ConfigurationImpl().setSecurityEnabled(false).setJournalMinFiles(2).setJournalFileSize(102400).setJournalType(ArtemisBrokerBase.getDefaultJournalType()).setJournalDirectory(this.getJournalDir(serverID, false)).setBindingsDirectory(this.getBindingsDir(serverID, false)).setPagingDirectory(this.getPageDir(serverID, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(serverID, false)).setJournalCompactMinFiles(0).setJournalCompactPercentage(0).setClusterPassword(CLUSTER_PASSWORD);
        return configuration;
    }

    protected String getLargeMessagesDir(int index, boolean backup) {
        return ArtemisBrokerBase.getLargeMessagesDir(this.testDir, index, backup);
    }

    protected static String getLargeMessagesDir(String testDir, int index, boolean backup) {
        return ArtemisBrokerBase.getLargeMessagesDir(testDir) + ArtemisBrokerBase.directoryNameSuffix(index, backup);
    }

    protected String getPageDir(int index, boolean backup) {
        return ArtemisBrokerBase.getPageDir(this.testDir, index, backup);
    }

    protected static String getPageDir(String testDir, int index, boolean backup) {
        return ArtemisBrokerBase.getPageDir(testDir) + ArtemisBrokerBase.directoryNameSuffix(index, backup);
    }

    protected String getBindingsDir(int index, boolean backup) {
        return ArtemisBrokerBase.getBindingsDir(this.testDir, index, backup);
    }

    protected static String getBindingsDir(String testDir, int index, boolean backup) {
        return ArtemisBrokerBase.getBindingsDir(testDir) + ArtemisBrokerBase.directoryNameSuffix(index, backup);
    }

    protected String getJournalDir(int index, boolean backup) {
        return ArtemisBrokerBase.getJournalDir(this.testDir, index, backup);
    }

    protected static String getJournalDir(String testDir, int index, boolean backup) {
        return ArtemisBrokerBase.getJournalDir(testDir) + ArtemisBrokerBase.directoryNameSuffix(index, backup);
    }

    private static String directoryNameSuffix(int index, boolean backup) {
        if (index == -1) {
            return "";
        }
        return index + "-" + (backup ? "B" : "L");
    }

    protected static JournalType getDefaultJournalType() {
        if (LibaioContext.isLoaded()) {
            return JournalType.ASYNCIO;
        }
        return JournalType.NIO;
    }

    protected final void clearDataRecreateServerDirs() {
        this.clearDataRecreateServerDirs(this.testDir);
    }

    protected void clearDataRecreateServerDirs(String testDir1) {
        File file = new File(testDir1);
        ArtemisBrokerBase.deleteDirectory(file);
        file.mkdirs();
        ArtemisBrokerBase.recreateDirectory(ArtemisBrokerBase.getJournalDir(testDir1));
        ArtemisBrokerBase.recreateDirectory(ArtemisBrokerBase.getBindingsDir(testDir1));
        ArtemisBrokerBase.recreateDirectory(ArtemisBrokerBase.getPageDir(testDir1));
        ArtemisBrokerBase.recreateDirectory(ArtemisBrokerBase.getLargeMessagesDir(testDir1));
        ArtemisBrokerBase.recreateDirectory(this.getClientLargeMessagesDir(testDir1));
        ArtemisBrokerBase.recreateDirectory(this.getTemporaryDir(testDir1));
    }

    protected String getTemporaryDir(String testDir1) {
        return testDir1 + "/temp";
    }

    protected String getClientLargeMessagesDir(String testDir1) {
        return testDir1 + "/client-large-msg";
    }

    protected static String getLargeMessagesDir(String testDir1) {
        return testDir1 + "/large-msg";
    }

    protected static String getPageDir(String testDir1) {
        return testDir1 + "/page";
    }

    protected static String getBindingsDir(String testDir1) {
        return testDir1 + "/bindings";
    }

    protected static String getJournalDir(String testDir1) {
        return testDir1 + "/journal";
    }

    protected static final void recreateDirectory(String directory) {
        File file = new File(directory);
        ArtemisBrokerBase.deleteDirectory(file);
        file.mkdirs();
    }

    protected static final boolean deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            String[] files = directory.list();
            int num = 5;
            for (int attempts = 0; files == null && attempts < num; ++attempts) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                files = directory.list();
            }
            for (String file : files) {
                File f = new File(directory, file);
                if (ArtemisBrokerBase.deleteDirectory(f)) continue;
                LOG.warn("Failed to clean up file: " + f.getAbsolutePath());
            }
        }
        return directory.delete();
    }

    public ActiveMQServer getServer() {
        return this.server;
    }
}

