/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.TransportLoggerSupport;
import org.apache.activemq.artemiswrapper.ArtemisBrokerHelper;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.InactivityMonitor;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.WireFormatNegotiator;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportFactory.class);
    private static volatile String brokerService = null;

    public static void setBrokerName(String name) {
        brokerService = name;
    }

    public Transport doConnect(URI location) throws Exception {
        Map params = URISupport.parseParameters((URI)location);
        String brokerId = (String)params.remove("invmBrokerId");
        params.clear();
        location = URISupport.createRemainingURI((URI)location, (Map)params);
        if (brokerService == null) {
            ArtemisBrokerHelper.startArtemisBroker(location);
            brokerService = location.toString();
            if (brokerId != null) {
                BrokerRegistry.getInstance().bind(brokerId, ArtemisBrokerHelper.getBroker());
                System.out.println("bound: " + brokerId);
            }
        }
        return super.doConnect(location);
    }

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParameters((URI)location));
            ServerSocketFactory serverSocketFactory = this.createServerSocketFactory();
            TcpTransportServer server = this.createTcpTransportServer(location, serverSocketFactory);
            server.setWireFormatFactory(this.createWireFormatFactory(options));
            IntrospectionSupport.setProperties((Object)server, options);
            Map transportOptions = IntrospectionSupport.extractProperties(options, (String)"transport.");
            server.setTransportOption(transportOptions);
            server.bind();
            return server;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        boolean useInactivityMonitor;
        TcpTransport tcpTransport = (TcpTransport)transport.narrow(TcpTransport.class);
        IntrospectionSupport.setProperties((Object)tcpTransport, (Map)options);
        Map socketOptions = IntrospectionSupport.extractProperties((Map)options, (String)"socket.");
        tcpTransport.setSocketOptions(socketOptions);
        if (tcpTransport.isTrace()) {
            try {
                transport = TransportLoggerSupport.createTransportLogger((Transport)transport, (String)tcpTransport.getLogWriterName(), (boolean)tcpTransport.isDynamicManagement(), (boolean)tcpTransport.isStartLogging(), (int)tcpTransport.getJmxPort());
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + tcpTransport.getLogWriterName() + ", reason: " + e, e);
            }
        }
        if ((useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) && this.isUseInactivityMonitor(transport)) {
            transport = this.createInactivityMonitor(transport, format);
            IntrospectionSupport.setProperties((Object)transport, (Map)options);
        }
        if (format instanceof OpenWireFormat) {
            transport = new WireFormatNegotiator(transport, (OpenWireFormat)format, tcpTransport.getMinmumWireFormatVersion());
        }
        return super.compositeConfigure(transport, format, options);
    }

    protected boolean isUseInactivityMonitor(Transport transport) {
        return true;
    }

    protected Transport createTransport(URI location, WireFormat wf) throws UnknownHostException, IOException {
        URI localLocation;
        block3: {
            localLocation = null;
            String path = location.getPath();
            if (path != null && path.length() > 0) {
                int localPortIndex = path.indexOf(58);
                try {
                    Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                    String localString = location.getScheme() + ":/" + path;
                    localLocation = new URI(localString);
                }
                catch (Exception e) {
                    LOG.warn("path isn't a valid local location for TcpTransport to use", (Object)e.getMessage());
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Failure detail", (Throwable)e);
                }
            }
        }
        SocketFactory socketFactory = this.createSocketFactory();
        return this.createTcpTransport(wf, socketFactory, location, localLocation);
    }

    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new TcpTransport(wf, socketFactory, location, localLocation);
    }

    protected ServerSocketFactory createServerSocketFactory() throws IOException {
        return ServerSocketFactory.getDefault();
    }

    protected SocketFactory createSocketFactory() throws IOException {
        return SocketFactory.getDefault();
    }

    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        return new InactivityMonitor(transport, format);
    }

    public static void clearService() {
        brokerService = null;
    }
}

