/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.MessageServiceConfiguration;
import org.apache.activemq.artemis.rest.queue.DestinationSettings;
import org.apache.activemq.artemis.rest.queue.QueueServiceManager;
import org.apache.activemq.artemis.rest.topic.TopicServiceManager;
import org.apache.activemq.artemis.rest.util.CustomHeaderLinkStrategy;
import org.apache.activemq.artemis.rest.util.LinkHeaderLinkStrategy;
import org.apache.activemq.artemis.rest.util.LinkStrategy;
import org.apache.activemq.artemis.rest.util.TimeoutTask;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.XMLUtil;

public class MessageServiceManager {
    private ExecutorService threadPool;
    private QueueServiceManager queueManager;
    private TopicServiceManager topicManager;
    private TimeoutTask timeoutTask;
    private int timeoutTaskInterval = 1;
    protected MessageServiceConfiguration configuration = new MessageServiceConfiguration();
    private boolean configSet = false;
    private String configResourcePath;
    protected BindingRegistry registry;
    private ClientSessionFactory consumerSessionFactory;

    public MessageServiceManager(ConnectionFactoryOptions jmsOptions) {
        this.queueManager = new QueueServiceManager(jmsOptions);
        this.topicManager = new TopicServiceManager(jmsOptions);
    }

    public BindingRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    public int getTimeoutTaskInterval() {
        return this.timeoutTaskInterval;
    }

    public void setTimeoutTaskInterval(int timeoutTaskInterval) {
        this.timeoutTaskInterval = timeoutTaskInterval;
        if (this.timeoutTask != null) {
            this.timeoutTask.setInterval(timeoutTaskInterval);
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public QueueServiceManager getQueueManager() {
        return this.queueManager;
    }

    public TopicServiceManager getTopicManager() {
        return this.topicManager;
    }

    public MessageServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getConfigResourcePath() {
        return this.configResourcePath;
    }

    public void setConfigResourcePath(String configResourcePath) {
        this.configResourcePath = configResourcePath;
    }

    public void setConfiguration(MessageServiceConfiguration configuration) {
        this.configuration = configuration;
        this.configSet = true;
    }

    public void start() throws Exception {
        if (this.configuration == null || !this.configSet) {
            if (this.configResourcePath == null) {
                this.configuration = new MessageServiceConfiguration();
            } else {
                URL url = this.getClass().getClassLoader().getResource(this.configResourcePath);
                if (this.isOutsideOfClassloader(url)) {
                    url = new URL(this.configResourcePath);
                }
                JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{MessageServiceConfiguration.class});
                InputStreamReader reader = new InputStreamReader(url.openStream());
                String xml = XMLUtil.readerToString((Reader)reader);
                xml = XMLUtil.replaceSystemProps((String)xml);
                this.configuration = (MessageServiceConfiguration)jaxb.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
            }
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        }
        this.timeoutTaskInterval = this.configuration.getTimeoutTaskInterval();
        this.timeoutTask = new TimeoutTask(this.timeoutTaskInterval);
        this.threadPool.execute(this.timeoutTask);
        DestinationSettings defaultSettings = new DestinationSettings();
        defaultSettings.setConsumerSessionTimeoutSeconds(this.configuration.getConsumerSessionTimeoutSeconds());
        defaultSettings.setDuplicatesAllowed(this.configuration.isDupsOk());
        defaultSettings.setDurableSend(this.configuration.isDefaultDurableSend());
        ServerLocator consumerLocator = ActiveMQClient.createServerLocator((String)this.configuration.getUrl());
        if (this.configuration.getConsumerWindowSize() != -1) {
            consumerLocator.setConsumerWindowSize(this.configuration.getConsumerWindowSize());
        }
        ActiveMQRestLogger.LOGGER.debug("Created ServerLocator: " + consumerLocator);
        this.consumerSessionFactory = consumerLocator.createSessionFactory();
        ActiveMQRestLogger.LOGGER.debug("Created ClientSessionFactory: " + this.consumerSessionFactory);
        ServerLocator defaultLocator = ActiveMQClient.createServerLocator((String)this.configuration.getUrl());
        ClientSessionFactory sessionFactory = defaultLocator.createSessionFactory();
        LinkStrategy linkStrategy = this.configuration.isUseLinkHeaders() ? new LinkHeaderLinkStrategy() : new CustomHeaderLinkStrategy();
        this.queueManager.setServerLocator(defaultLocator);
        this.queueManager.setSessionFactory(sessionFactory);
        this.queueManager.setTimeoutTask(this.timeoutTask);
        this.queueManager.setConsumerServerLocator(consumerLocator);
        this.queueManager.setConsumerSessionFactory(this.consumerSessionFactory);
        this.queueManager.setDefaultSettings(defaultSettings);
        this.queueManager.setPushStoreFile(this.configuration.getQueuePushStoreDirectory());
        this.queueManager.setProducerPoolSize(this.configuration.getProducerSessionPoolSize());
        this.queueManager.setProducerTimeToLive(this.configuration.getProducerTimeToLive());
        this.queueManager.setLinkStrategy(linkStrategy);
        this.queueManager.setRegistry(this.registry);
        this.topicManager.setServerLocator(defaultLocator);
        this.topicManager.setSessionFactory(sessionFactory);
        this.topicManager.setTimeoutTask(this.timeoutTask);
        this.topicManager.setConsumerServerLocator(consumerLocator);
        this.topicManager.setConsumerSessionFactory(this.consumerSessionFactory);
        this.topicManager.setDefaultSettings(defaultSettings);
        this.topicManager.setPushStoreFile(this.configuration.getTopicPushStoreDirectory());
        this.topicManager.setProducerPoolSize(this.configuration.getProducerSessionPoolSize());
        this.queueManager.setProducerTimeToLive(this.configuration.getProducerTimeToLive());
        this.topicManager.setLinkStrategy(linkStrategy);
        this.topicManager.setRegistry(this.registry);
        this.queueManager.start();
        this.topicManager.start();
    }

    private boolean isOutsideOfClassloader(URL url) {
        return url == null;
    }

    public void stop() {
        if (this.queueManager != null) {
            this.queueManager.stop();
        }
        this.queueManager = null;
        if (this.topicManager != null) {
            this.topicManager.stop();
        }
        this.topicManager = null;
        this.timeoutTask.stop();
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(5000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.consumerSessionFactory.close();
    }
}

