/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.rest.queue.push.xml.XmlLink;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface ActiveMQRestLogger
extends BasicLogger {
    public static final ActiveMQRestLogger LOGGER = (ActiveMQRestLogger)Logger.getMessageLogger(ActiveMQRestLogger.class, (String)ActiveMQRestLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181000, value="Loading REST push store from: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void loadingRestStore(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181001, value="adding REST push registration: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void addingPushRegistration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181002, value="Push consumer started for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void startingPushConsumer(XmlLink var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182000, value="shutdown REST consumer because of timeout for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void shutdownRestConsumer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182001, value="shutdown REST subscription because of timeout for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void shutdownRestSubscription(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182002, value="Failed to push message to {0}", format=Message.Format.MESSAGE_FORMAT)
    public void failedToPushMessageToUri(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182003, value="Failed to build Message from object", format=Message.Format.MESSAGE_FORMAT)
    public void failedToBuildMessageFromObject(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182004, value="REST configuration parameter ''{0}'' is deprecated. Use ''{1}'' instead.", format=Message.Format.MESSAGE_FORMAT)
    public void deprecatedConfiguration(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184000, value="Failed to load push store {0}, it is probably corrupted", format=Message.Format.MESSAGE_FORMAT)
    public void errorLoadingStore(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184001, value="Error updating store", format=Message.Format.MESSAGE_FORMAT)
    public void errorUpdatingStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184002, value="Failed to push message to {0} disabling push registration...", format=Message.Format.MESSAGE_FORMAT)
    public void errorPushingMessage(XmlLink var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184003, value="Error deleting Subscriber queue", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingSubscriberQueue(@Cause ActiveMQException var1);
}

