/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.rest.HttpHeaderProperty;
import org.apache.activemq.artemis.rest.UnknownMediaType;
import org.apache.activemq.artemis.rest.UnmarshalException;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GenericType;

public class ActiveMQ {
    public static void setEntity(ClientMessage message, Serializable object) {
        ActiveMQ.setEntity(message, object, null);
    }

    public static void setEntity(ClientMessage message, Serializable object, String contentType) {
        byte[] data;
        if (contentType != null) {
            message.putStringProperty("http_content$type", contentType);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            data = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        message.getBodyBuffer().writeInt(data.length);
        message.getBodyBuffer().writeBytes(data);
    }

    public static void setHttpHeader(ClientMessage message, String name, String value) {
        message.putStringProperty(HttpHeaderProperty.toPropertyName(name), value);
    }

    public static String getHttpHeader(ClientMessage message, String name) {
        return message.getStringProperty(HttpHeaderProperty.toPropertyName(name));
    }

    public static <T> T getEntity(ClientMessage message, Class<T> type) {
        return ActiveMQ.getEntity(message, type, null, ResteasyProviderFactory.getInstance());
    }

    public static <T> T getEntity(ClientMessage message, Class<T> type, ResteasyProviderFactory factory) {
        return ActiveMQ.getEntity(message, type, null, factory);
    }

    public static <T> T getEntity(ClientMessage message, GenericType<T> type, ResteasyProviderFactory factory) throws UnknownMediaType, UnmarshalException {
        return ActiveMQ.getEntity(message, type.getType(), type.getGenericType(), factory);
    }

    public static <T> T getEntity(ClientMessage msg, Class<T> type, Type genericType, ResteasyProviderFactory factory) {
        int size = msg.getBodySize();
        if (size <= 0) {
            return null;
        }
        byte[] body = new byte[size];
        msg.getBodyBuffer().readBytes(body);
        String contentType = msg.getStringProperty("http_content$type");
        if (contentType == null) {
            throw new UnknownMediaType("Message did not have a Content-Type header cannot extract entity");
        }
        MediaType ct = MediaType.valueOf((String)contentType);
        MessageBodyReader reader = factory.getMessageBodyReader(type, genericType, null, ct);
        if (reader == null) {
            throw new UnmarshalException("Unable to find a JAX-RS reader for type " + type.getName() + " and media type " + contentType);
        }
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)factory);
        try {
            Object object = reader.readFrom(type, genericType, null, ct, (MultivaluedMap)new Headers(), (InputStream)new ByteArrayInputStream(body));
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
        }
    }

    public static boolean isHttpMessage(ClientMessage msg) {
        Boolean aBoolean = msg.getBooleanProperty("postedAsHttpMessage");
        return aBoolean != null && aBoolean == true;
    }
}

