/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.utils.FileUtil;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.logging.Logger;

public class WebServerComponent
implements ExternalComponent {
    private static final Logger logger = Logger.getLogger(WebServerComponent.class);
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;
    private URI uri;
    private String consoleUrl;
    private List<WebAppContext> webContexts;
    private ServerConnector connector;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.uri = new URI(this.webServerConfig.bind);
        this.server = new Server();
        String scheme = this.uri.getScheme();
        if ("https".equals(scheme)) {
            SslContextFactory sslFactory = new SslContextFactory();
            sslFactory.setKeyStorePath(this.webServerConfig.keyStorePath == null ? artemisInstance + "/etc/keystore.jks" : this.webServerConfig.keyStorePath);
            sslFactory.setKeyStorePassword(this.webServerConfig.getKeyStorePassword() == null ? "password" : this.webServerConfig.getKeyStorePassword());
            if (this.webServerConfig.clientAuth != null) {
                sslFactory.setNeedClientAuth(this.webServerConfig.clientAuth.booleanValue());
                if (this.webServerConfig.clientAuth.booleanValue()) {
                    sslFactory.setTrustStorePath(this.webServerConfig.trustStorePath);
                    sslFactory.setTrustStorePassword(this.webServerConfig.getTrustStorePassword());
                }
            }
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslFactory, "HTTP/1.1");
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            https.setSendServerVersion(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(https);
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, httpFactory});
        } else {
            HttpConfiguration configuration = new HttpConfiguration();
            configuration.setSendServerVersion(false);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(configuration);
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{connectionFactory});
        }
        this.connector.setPort(this.uri.getPort());
        this.connector.setHost(this.uri.getHost());
        this.server.setConnectors(new Connector[]{this.connector});
        this.handlers = new HandlerList();
        Path homeWarDir = Paths.get(artemisHome != null ? artemisHome : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        Path instanceWarDir = Paths.get(artemisInstance != null ? artemisInstance : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        if (this.webServerConfig.apps != null && this.webServerConfig.apps.size() > 0) {
            this.webContexts = new ArrayList<WebAppContext>();
            for (AppDTO app : this.webServerConfig.apps) {
                Path dirToUse = homeWarDir;
                if (new File(instanceWarDir.toFile().toString() + File.separator + app.war).exists()) {
                    dirToUse = instanceWarDir;
                }
                WebAppContext webContext = this.deployWar(app.url, app.war, dirToUse);
                this.webContexts.add(webContext);
                if (!app.war.startsWith("console")) continue;
                this.consoleUrl = this.webServerConfig.bind + "/" + app.url;
            }
        }
        ResourceHandler homeResourceHandler = new ResourceHandler();
        homeResourceHandler.setResourceBase(homeWarDir.toString());
        homeResourceHandler.setDirectoriesListed(false);
        homeResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler homeContext = new ContextHandler();
        homeContext.setContextPath("/");
        homeContext.setResourceBase(homeWarDir.toString());
        homeContext.setHandler((Handler)homeResourceHandler);
        homeContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ResourceHandler instanceResourceHandler = new ResourceHandler();
        instanceResourceHandler.setResourceBase(instanceWarDir.toString());
        instanceResourceHandler.setDirectoriesListed(false);
        instanceResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler instanceContext = new ContextHandler();
        instanceContext.setContextPath("/");
        instanceContext.setResourceBase(instanceWarDir.toString());
        instanceContext.setHandler((Handler)instanceResourceHandler);
        homeContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)homeContext);
        this.handlers.addHandler((Handler)instanceContext);
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.server.start();
        ActiveMQWebLogger.LOGGER.webserverStarted(this.webServerConfig.bind);
        if (this.consoleUrl != null) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(this.consoleUrl + "/jolokia");
            ActiveMQWebLogger.LOGGER.consoleAvailable(this.consoleUrl);
        }
    }

    public void internalStop() throws Exception {
        this.server.stop();
        if (this.webContexts != null) {
            File tmpdir = null;
            for (WebAppContext context : this.webContexts) {
                tmpdir = context.getTempDirectory();
                if (tmpdir == null || context.isPersistTempDirectory()) continue;
                boolean fileDeleted = TimeUtils.waitOnBoolean((boolean)false, (long)5000L, tmpdir::exists);
                if (fileDeleted) continue;
                FileUtil.deleteDirectory((File)tmpdir);
                logger.debug((Object)("Force to delete temporary file on shutdown: " + tmpdir.getAbsolutePath()));
                if (!tmpdir.exists()) continue;
                ActiveMQWebLogger.LOGGER.tmpFileNotDeleted(tmpdir);
            }
            this.webContexts.clear();
        }
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    public int getPort() {
        return this.connector != null ? this.connector.getLocalPort() : -1;
    }

    private WebAppContext deployWar(String url, String warFile, Path warDirectory) throws IOException {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.setWar(warDirectory.resolve(warFile).toString());
        this.handlers.addHandler((Handler)webapp);
        return webapp;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    public void stop(boolean isShutdown) throws Exception {
        if (isShutdown) {
            this.internalStop();
        }
    }
}

