/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wait {
    private static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final long MAX_WAIT_MILLIS = 30000L;
    public static final int SLEEP_MILLIS = 100;
    public static final String DEFAULT_FAILURE_MESSAGE = "Condition wasn't met";
    private static Method tdUtilMethod;

    public static boolean waitFor(Condition condition) throws Exception {
        return Wait.waitFor(condition, 30000L);
    }

    public static void assertEquals(Object obj, ObjectCondition condition) throws Exception {
        Wait.assertEquals(obj, condition, 30000L, 100L);
    }

    public static void assertEquals(long size, LongCondition condition) throws Exception {
        Wait.assertEquals(size, condition, 30000L);
    }

    public static void assertEquals(long size, LongCondition condition, long timeout) throws Exception {
        Wait.assertEquals(size, condition, timeout, 100L);
    }

    public static void assertEquals(Long size, LongCondition condition, long timeout, long sleepMillis) throws Exception {
        Wait.assertEquals(size, condition, timeout, sleepMillis, false);
    }

    public static void assertEquals(Long size, LongCondition condition, long timeout, long sleepMillis, boolean printThreadDump) throws Exception {
        Wait.checkForThreadDumpUtil(printThreadDump);
        boolean result = Wait.waitFor(() -> condition.getCount() == size.longValue(), timeout, sleepMillis, printThreadDump);
        if (!result) {
            if (printThreadDump) {
                Wait.callThreadDumpUtil("thread dump");
            }
            Assertions.assertEquals((long)size, (long)condition.getCount());
        }
    }

    public static void assertEquals(int size, IntCondition condition) throws Exception {
        Wait.assertEquals(size, condition, 30000L);
    }

    public static void assertEquals(int size, IntCondition condition, long timeout) throws Exception {
        Wait.assertEquals(size, condition, timeout, 100L);
    }

    public static void assertEquals(Object obj, ObjectCondition condition, long timeout, long sleepMillis) throws Exception {
        boolean result = Wait.waitFor(() -> obj == condition || obj != null && obj.equals(condition.getObject()), timeout, sleepMillis);
        if (!result) {
            Assertions.assertEquals((Object)obj, (Object)condition.getObject());
        }
    }

    public static void assertEquals(int size, IntCondition condition, long timeout, long sleepMillis) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size, timeout, sleepMillis);
        if (!result) {
            Assertions.assertEquals((int)size, (int)condition.getCount());
        }
    }

    public static void assertEquals(int size, IntCondition condition, long timeout, long sleepMillis, Supplier<String> messageSupplier) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size, timeout, sleepMillis);
        if (!result) {
            Assertions.assertEquals((int)size, (int)condition.getCount(), messageSupplier);
        }
    }

    public static void assertThrows(Class type, ExceptionCondition condition, long timeout, long sleepMillis, Supplier<String> messageSupplier) throws Exception {
        AtomicReference ref = new AtomicReference();
        boolean result = Wait.waitFor(() -> {
            block2: {
                try {
                    condition.isSatisfied();
                }
                catch (Exception e) {
                    ref.set(e);
                    if (!type.isInstance(e)) break block2;
                    return true;
                }
            }
            return false;
        }, timeout, sleepMillis);
        if (!result) {
            Assertions.assertThrows((Class)type, () -> {
                if (ref.get() != null) {
                    throw (Exception)ref.get();
                }
            }, messageSupplier);
        }
    }

    public static void assertTrue(Condition condition) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition);
    }

    public static void assertFalse(Condition condition) {
        Wait.assertTrue(() -> !condition.isSatisfied());
    }

    public static void assertFalse(String failureMessage, Condition condition) {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied());
    }

    public static void assertFalse(String failureMessage, Condition condition, long duration) {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied(), duration, 100L);
    }

    public static void assertFalse(Supplier<String> failureMessage, Condition condition, long duration, long sleep) {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied(), duration, sleep);
    }

    public static void assertFalse(Condition condition, long duration, long sleep) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, () -> !condition.isSatisfied(), duration, sleep);
    }

    public static void assertTrue(Condition condition, long duration) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition, duration, 100L);
    }

    public static void assertTrue(String failureMessage, Condition condition) {
        Wait.assertTrue(failureMessage, condition, 30000L);
    }

    public static void assertTrue(String failureMessage, Condition condition, long duration) {
        Wait.assertTrue(failureMessage, condition, duration, 100L);
    }

    public static <T> T assertNotNull(Supplier<T> supplier, long duration, long sleep) throws Exception {
        Assertions.assertTrue((boolean)Wait.waitFor(() -> supplier.get() != null, duration, sleep));
        return supplier.get();
    }

    public static void assertTrue(Condition condition, long duration, long sleep) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition, duration, sleep);
    }

    public static void assertTrue(String failureMessage, Condition condition, long duration, long sleep) {
        Wait.assertTrue(() -> failureMessage, condition, duration, sleep);
    }

    public static void assertTrue(Supplier<String> failureMessage, Condition condition, long duration, long sleep) {
        boolean result = Wait.waitFor(condition, duration, sleep);
        if (!result) {
            Assertions.fail((String)failureMessage.get());
        }
    }

    public static boolean waitFor(Condition condition, long duration) throws Exception {
        return Wait.waitFor(condition, duration, 100L);
    }

    public static boolean waitFor(Condition condition, long durationMillis, long sleepMillis) {
        return Wait.waitFor(condition, durationMillis, sleepMillis, false);
    }

    public static boolean waitFor(Condition condition, long durationMillis, long sleepMillis, boolean printThreadDump) {
        Wait.checkForThreadDumpUtil(printThreadDump);
        try {
            long expiry = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(durationMillis);
            boolean conditionSatisified = condition.isSatisfied();
            while (!conditionSatisified && System.nanoTime() - expiry < 0L) {
                if (sleepMillis == 0L) {
                    Thread.yield();
                } else {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(sleepMillis));
                }
                conditionSatisified = condition.isSatisfied();
            }
            if (!conditionSatisified && printThreadDump) {
                Wait.callThreadDumpUtil("thread dump");
            }
            return conditionSatisified;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void checkForThreadDumpUtil(boolean printThreadDump) {
        if (printThreadDump && tdUtilMethod == null) {
            throw new IllegalStateException("Unable to identify ThreadDumpUtil class/method.");
        }
    }

    private static void callThreadDumpUtil(String msg) {
        Wait.checkForThreadDumpUtil(true);
        try {
            Object threadDump = tdUtilMethod.invoke(null, msg);
            System.out.println(threadDump);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure running ThreadDumpUtil", e);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.apache.activemq.artemis.utils.ThreadDumpUtil");
            tdUtilMethod = clazz.getMethod("threadDump", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Wait util was unable to locate ThreadDumpUtil class/method", (Throwable)e);
            }
            logger.info("Wait util was unable to locate ThreadDumpUtil class/method due to: {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }

    public static interface ObjectCondition {
        public Object getObject() throws Exception;
    }

    public static interface LongCondition {
        public long getCount() throws Exception;
    }

    public static interface IntCondition {
        public int getCount() throws Exception;
    }

    public static interface ExceptionCondition {
        public void isSatisfied() throws Exception;
    }
}

