/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.stomp.Stomp;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.reader.MessageUtil;

public class StompUtils {
    private static final String DEFAULT_MESSAGE_PRIORITY = "4";

    public static void copyStandardHeadersFromFrameToMessage(StompFrame frame, ServerMessageImpl msg) throws Exception {
        String expiration;
        Object replyTo;
        String contentType;
        HashMap<String, String> headers = new HashMap<String, String>(frame.getHeadersMap());
        String priority = (String)headers.remove("priority");
        if (priority != null) {
            msg.setPriority(Byte.parseByte(priority));
        } else {
            msg.setPriority(Byte.parseByte(DEFAULT_MESSAGE_PRIORITY));
        }
        String persistent = (String)headers.remove(Stomp.Headers.Send.PERSISTENT);
        if (persistent != null) {
            msg.setDurable(Boolean.parseBoolean(persistent));
        }
        msg.putObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME, headers.remove("correlation-id"));
        msg.putObjectProperty(MessageUtil.TYPE_HEADER_NAME, headers.remove("type"));
        String groupID = (String)headers.remove("JMSXGroupID");
        if (groupID != null) {
            msg.putStringProperty(Message.HDR_GROUP_ID, SimpleString.toSimpleString((String)groupID));
        }
        if ((contentType = (String)headers.remove("content-type")) != null) {
            msg.putStringProperty(Message.HDR_CONTENT_TYPE, SimpleString.toSimpleString((String)contentType));
        }
        if ((replyTo = headers.remove("reply-to")) != null) {
            msg.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, SimpleString.toSimpleString((String)((String)replyTo)));
        }
        if ((expiration = (String)headers.remove("expires")) != null) {
            msg.setExpiration(Long.parseLong(expiration));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            msg.putObjectProperty(name, value);
        }
    }

    public static void copyStandardHeadersFromMessageToFrame(MessageInternal message, StompFrame command, int deliveryCount) throws Exception {
        command.addHeader("message-id", String.valueOf(message.getMessageID()));
        command.addHeader("destination", message.getAddress().toString());
        if (message.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME) != null) {
            command.addHeader("correlation-id", message.getObjectProperty(MessageUtil.CORRELATIONID_HEADER_NAME).toString());
        }
        command.addHeader("expires", "" + message.getExpiration());
        command.addHeader("redelivered", String.valueOf(deliveryCount > 1));
        command.addHeader("priority", "" + message.getPriority());
        command.addHeader("persistent", "" + message.isDurable());
        if (message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME) != null) {
            command.addHeader("reply-to", message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME));
        }
        command.addHeader("timestamp", "" + message.getTimestamp());
        if (message.getObjectProperty(MessageUtil.TYPE_HEADER_NAME) != null) {
            command.addHeader("type", message.getObjectProperty(MessageUtil.TYPE_HEADER_NAME).toString());
        }
        if (message.getStringProperty(Message.HDR_CONTENT_TYPE.toString()) != null) {
            command.addHeader("content-type", message.getStringProperty(Message.HDR_CONTENT_TYPE.toString()));
        }
        if (message.getStringProperty(Message.HDR_VALIDATED_USER.toString()) != null) {
            command.addHeader("JMSXUserID", message.getStringProperty(Message.HDR_VALIDATED_USER.toString()));
        }
        Set names = message.getPropertyNames();
        for (SimpleString name : names) {
            if (name.equals((Object)ClientMessageImpl.REPLYTO_HEADER_NAME) || name.equals((Object)Message.HDR_CONTENT_TYPE) || name.equals((Object)Message.HDR_VALIDATED_USER) || name.equals((Object)MessageUtil.TYPE_HEADER_NAME) || name.equals((Object)MessageUtil.CORRELATIONID_HEADER_NAME) || name.toString().equals("destination")) continue;
            command.addHeader(name.toString(), message.getObjectProperty(name).toString());
        }
    }
}

