/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public class ActiveMQJAASSecurityManager
implements ActiveMQSecurityManager3 {
    private static final Logger logger = Logger.getLogger(ActiveMQJAASSecurityManager.class);
    private static final String WILDCARD = "*";
    private String configurationName;
    private String certificateConfigurationName;
    private SecurityConfiguration configuration;
    private SecurityConfiguration certificateConfiguration;
    private String rolePrincipalClass = "org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal";

    public ActiveMQJAASSecurityManager() {
    }

    public ActiveMQJAASSecurityManager(String configurationName) {
        this.configurationName = configurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, String certificateConfigurationName) {
        this.configurationName = configurationName;
        this.certificateConfigurationName = certificateConfigurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, SecurityConfiguration configuration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
    }

    public ActiveMQJAASSecurityManager(String configurationName, String certificateConfigurationName, SecurityConfiguration configuration, SecurityConfiguration certificateConfiguration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
        this.certificateConfigurationName = certificateConfigurationName;
        this.certificateConfiguration = certificateConfiguration;
    }

    @Override
    public boolean validateUser(String user, String password) {
        throw new UnsupportedOperationException("Invoke validateUser(String, String, X509Certificate[]) instead");
    }

    @Override
    public String validateUser(String user, String password, RemotingConnection remotingConnection) {
        try {
            return this.getUserFromSubject(this.getAuthenticatedSubject(user, password, remotingConnection));
        }
        catch (LoginException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't validate user", (Throwable)e);
            }
            return null;
        }
    }

    public String getUserFromSubject(Subject subject) {
        String validatedUser = "";
        Set<UserPrincipal> users = subject.getPrincipals(UserPrincipal.class);
        for (UserPrincipal userPrincipal : users) {
            validatedUser = userPrincipal.getName();
        }
        return validatedUser;
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        throw new UnsupportedOperationException("Invoke validateUserAndRole(String, String, Set<Role>, CheckType, String, RemotingConnection) instead");
    }

    @Override
    public String validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType, String address, RemotingConnection remotingConnection) {
        Subject localSubject;
        try {
            localSubject = this.getAuthenticatedSubject(user, password, remotingConnection);
        }
        catch (LoginException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Couldn't validate user", (Throwable)e);
            }
            return null;
        }
        boolean authorized = false;
        if (localSubject != null) {
            Set<RolePrincipal> rolesWithPermission = this.getPrincipalsInRole(checkType, roles);
            HashSet<Principal> rolesForSubject = new HashSet<Principal>();
            try {
                rolesForSubject.addAll(localSubject.getPrincipals(Class.forName(this.rolePrincipalClass).asSubclass(Principal.class)));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToFindRolesForTheSubject(e);
            }
            if (rolesForSubject.size() > 0 && rolesWithPermission.size() > 0) {
                Iterator rolesForSubjectIter = rolesForSubject.iterator();
                while (!authorized && rolesForSubjectIter.hasNext()) {
                    Iterator<RolePrincipal> rolesWithPermissionIter = rolesWithPermission.iterator();
                    Principal subjectRole = (Principal)rolesForSubjectIter.next();
                    while (!authorized && rolesWithPermissionIter.hasNext()) {
                        Principal roleWithPermission = rolesWithPermissionIter.next();
                        authorized = subjectRole.equals(roleWithPermission);
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("user " + (authorized ? " is " : " is NOT ") + "authorized"));
            }
        }
        if (authorized) {
            return this.getUserFromSubject(localSubject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject getAuthenticatedSubject(String user, String password, RemotingConnection remotingConnection) throws LoginException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisLoader = this.getClass().getClassLoader();
        try {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(thisLoader);
            }
            LoginContext lc = this.certificateConfigurationName != null && this.certificateConfigurationName.length() > 0 && CertificateUtil.getCertsFromConnection((RemotingConnection)remotingConnection) != null ? new LoginContext(this.certificateConfigurationName, null, new JaasCallbackHandler(user, password, remotingConnection), this.certificateConfiguration) : new LoginContext(this.configurationName, null, new JaasCallbackHandler(user, password, remotingConnection), this.configuration);
            lc.login();
            Subject subject = lc.getSubject();
            return subject;
        }
        finally {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
        }
    }

    private Set<RolePrincipal> getPrincipalsInRole(CheckType checkType, Set<Role> roles) {
        HashSet<RolePrincipal> principals = new HashSet<RolePrincipal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            try {
                principals.add((RolePrincipal)ActiveMQJAASSecurityManager.createGroupPrincipal(role.getName(), this.rolePrincipalClass));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedAddRolePrincipal(e);
            }
        }
        return principals;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfiguration(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCertificateConfigurationName(String certificateConfigurationName) {
        this.certificateConfigurationName = certificateConfigurationName;
    }

    public void setCertificateConfiguration(SecurityConfiguration certificateConfiguration) {
        this.certificateConfiguration = certificateConfiguration;
    }

    public SecurityConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SecurityConfiguration();
        }
        return this.configuration;
    }

    public SecurityConfiguration getCertificateConfiguration() {
        if (this.certificateConfiguration == null) {
            this.certificateConfiguration = new SecurityConfiguration();
        }
        return this.certificateConfiguration;
    }

    public String getRolePrincipalClass() {
        return this.rolePrincipalClass;
    }

    public void setRolePrincipalClass(String rolePrincipalClass) {
        this.rolePrincipalClass = rolePrincipalClass;
    }

    public static Object createGroupPrincipal(String name, String groupClass) throws Exception {
        Object instance;
        Class<?>[] paramTypes;
        int i;
        if (WILDCARD.equals(name)) {
            return new Principal(){

                @Override
                public String getName() {
                    return ActiveMQJAASSecurityManager.WILDCARD;
                }

                @Override
                public boolean equals(Object other) {
                    return true;
                }

                @Override
                public int hashCode() {
                    return ActiveMQJAASSecurityManager.WILDCARD.hashCode();
                }
            };
        }
        Object[] param = new Object[]{name};
        Class<?> cls = Class.forName(groupClass);
        Constructor<?>[] constructors = cls.getConstructors();
        for (i = 0; !(i >= constructors.length || (paramTypes = constructors[i].getParameterTypes()).length != 0 && paramTypes[0].equals(String.class)); ++i) {
        }
        if (i < constructors.length) {
            instance = constructors[i].newInstance(param);
        } else {
            Class<?>[] paramTypes2;
            instance = cls.newInstance();
            Method[] methods = cls.getMethods();
            i = 0;
            for (i = 0; !(i >= methods.length || (paramTypes2 = methods[i].getParameterTypes()).length != 0 && methods[i].getName().equals("setName") && paramTypes2[0].equals(String.class)); ++i) {
            }
            if (i < methods.length) {
                methods[i].invoke(instance, param);
            } else {
                throw new NoSuchMethodException();
            }
        }
        return instance;
    }
}

