/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.List;
import java.util.Set;
import javax.json.JsonArrayBuilder;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.Closeable;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public interface ServerSession
extends SecurityAuth {
    public String getName();

    public int getMinLargeMessageSize();

    public Object getConnectionID();

    public void enableSecurity();

    public void disableSecurity();

    @Override
    public RemotingConnection getRemotingConnection();

    public Transaction newTransaction();

    public boolean removeConsumer(long var1) throws Exception;

    public void acknowledge(long var1, long var3) throws Exception;

    public void individualAcknowledge(long var1, long var3) throws Exception;

    public void individualCancel(long var1, long var3, boolean var5) throws Exception;

    public void expire(long var1, long var3) throws Exception;

    public void rollback(boolean var1) throws Exception;

    public void commit() throws Exception;

    public void xaCommit(Xid var1, boolean var2) throws Exception;

    public void xaEnd(Xid var1) throws Exception;

    public void xaForget(Xid var1) throws Exception;

    public void xaJoin(Xid var1) throws Exception;

    public void xaPrepare(Xid var1) throws Exception;

    public void xaResume(Xid var1) throws Exception;

    public void xaRollback(Xid var1) throws Exception;

    public void xaStart(Xid var1) throws Exception;

    public void xaFailed(Xid var1) throws Exception;

    public void xaSuspend() throws Exception;

    public void markTXFailed(Throwable var1);

    public List<Xid> xaGetInDoubtXids();

    public int xaGetTimeout();

    public void xaSetTimeout(int var1);

    public void start();

    public void stop();

    public void addCloseable(Closeable var1);

    public void resetTX(Transaction var1);

    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6) throws Exception;

    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9) throws Exception;

    public Queue createQueue(SimpleString var1, SimpleString var2, RoutingType var3, SimpleString var4, boolean var5, boolean var6, boolean var7) throws Exception;

    public AddressInfo createAddress(SimpleString var1, Set<RoutingType> var2, boolean var3) throws Exception;

    public AddressInfo createAddress(SimpleString var1, RoutingType var2, boolean var3) throws Exception;

    public void deleteQueue(SimpleString var1) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, boolean var5) throws Exception;

    public ServerConsumer createConsumer(long var1, SimpleString var3, SimpleString var4, boolean var5, boolean var6, Integer var7) throws Exception;

    public QueueQueryResult executeQueueQuery(SimpleString var1) throws Exception;

    public AddressQueryResult executeAddressQuery(SimpleString var1) throws Exception;

    public BindingQueryResult executeBindingQuery(SimpleString var1) throws Exception;

    public void closeConsumer(long var1) throws Exception;

    public void receiveConsumerCredits(long var1, int var3) throws Exception;

    public RoutingStatus send(Transaction var1, Message var2, boolean var3, boolean var4) throws Exception;

    public RoutingStatus doSend(Transaction var1, Message var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public RoutingStatus send(Message var1, boolean var2, boolean var3) throws Exception;

    public RoutingStatus send(Message var1, boolean var2) throws Exception;

    public void forceConsumerDelivery(long var1, long var3) throws Exception;

    public void requestProducerCredits(SimpleString var1, int var2) throws Exception;

    public void close(boolean var1) throws Exception;

    public void waitContextCompletion() throws Exception;

    public void setTransferring(boolean var1);

    public Set<ServerConsumer> getServerConsumers();

    public void addMetaData(String var1, String var2);

    public boolean addUniqueMetaData(String var1, String var2);

    public String getMetaData(String var1);

    public String[] getTargetAddresses();

    public void describeProducersInfo(JsonArrayBuilder var1) throws Exception;

    public String getLastSentMessageID(String var1);

    public long getCreationTime();

    public OperationContext getSessionContext();

    public Transaction getCurrentTransaction();

    public ServerConsumer locateConsumer(long var1) throws Exception;

    public boolean isClosed();

    public void createSharedQueue(SimpleString var1, SimpleString var2, RoutingType var3, boolean var4, SimpleString var5) throws Exception;

    public void createSharedQueue(SimpleString var1, SimpleString var2, boolean var3, SimpleString var4) throws Exception;

    public List<MessageReference> getInTXMessagesForConsumer(long var1);

    public String getValidatedUser();

    public SimpleString getMatchingQueue(SimpleString var1, RoutingType var2) throws Exception;

    public SimpleString getMatchingQueue(SimpleString var1, SimpleString var2, RoutingType var3) throws Exception;

    public AddressInfo getAddress(SimpleString var1);

    public SimpleString removePrefix(SimpleString var1);

    public Pair<SimpleString, RoutingType> getAddressAndRoutingType(SimpleString var1, RoutingType var2);

    public Pair<SimpleString, Set<RoutingType>> getAddressAndRoutingTypes(SimpleString var1, Set<RoutingType> var2);
}

