/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.cluster.qourum.SharedNothingBackupQuorum;
import org.apache.activemq.artemis.utils.ConcurrentUtil;

public class NamedLiveNodeLocatorForReplication
extends LiveNodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final String backupGroupName;
    private Pair<TransportConfiguration, TransportConfiguration> liveConfiguration;
    private String nodeID;

    public NamedLiveNodeLocatorForReplication(String backupGroupName, SharedNothingBackupQuorum quorumManager) {
        super(quorumManager);
        this.backupGroupName = backupGroupName;
    }

    @Override
    public void locateNode() throws ActiveMQException {
        this.locateNode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode(long timeout) throws ActiveMQException {
        block8: {
            try {
                this.lock.lock();
                if (this.liveConfiguration != null) break block8;
                try {
                    if (timeout != -1L) {
                        ConcurrentUtil.await((Condition)this.condition, (long)timeout);
                    } else {
                        while (this.liveConfiguration == null) {
                            this.condition.await();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            if (this.backupGroupName.equals(topologyMember.getBackupGroupName()) && topologyMember.getLive() != null) {
                this.liveConfiguration = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                this.nodeID = topologyMember.getNodeId();
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        return this.liveConfiguration;
    }

    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            this.liveConfiguration = null;
            super.notifyRegistrationFailed(alreadyReplicating);
        }
        finally {
            this.lock.unlock();
        }
    }
}

