/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.persistence.QueueStatus;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.QueueEncoding;

public class QueueStatusEncoding
extends QueueEncoding {
    private QueueStatus status;
    private long id;

    public QueueStatusEncoding(long queueID, QueueStatus status) {
        super(queueID);
        this.status = status;
    }

    public QueueStatusEncoding() {
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        super.decode(buffer);
        short shortStatus = buffer.readShort();
        this.status = QueueStatus.fromID(shortStatus);
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        super.encode(buffer);
        buffer.writeShort(this.status.id);
    }

    public QueueStatus getStatus() {
        return this.status;
    }

    public long getId() {
        return this.id;
    }

    public QueueStatusEncoding setId(long id) {
        this.id = id;
        return this;
    }

    @Override
    public int getEncodeSize() {
        return super.getEncodeSize() + 2;
    }

    @Override
    public String toString() {
        return "QueueStatusEncoding [id=" + this.id + ", queueID=" + this.queueID + ", status=" + (Object)((Object)this.status) + "]";
    }
}

