/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationDeleteMessage
extends PacketImpl {
    private long id;
    private byte journalID;

    public ReplicationDeleteMessage() {
        super((byte)93);
    }

    public ReplicationDeleteMessage(byte journalID, long id) {
        this();
        this.journalID = journalID;
        this.id = id;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.id);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.id = buffer.readLong();
    }

    public long getId() {
        return this.id;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.journalID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationDeleteMessage)) {
            return false;
        }
        ReplicationDeleteMessage other = (ReplicationDeleteMessage)((Object)obj);
        if (this.id != other.id) {
            return false;
        }
        return this.journalID == other.journalID;
    }
}

