/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;

public class ConnectionFactoryProperties
implements ConnectionFactoryOptions {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private boolean hasBeenUpdated = false;
    private List<String> connectorClassName;
    private List<Map<String, Object>> connectionParameters;
    private Boolean ha;
    private String connectionLoadBalancingPolicyClassName;
    private String jgroupsFile;
    private String jgroupsChannelName;
    private String discoveryAddress;
    private Integer discoveryPort;
    private String discoveryLocalBindAddress;
    private Long discoveryRefreshTimeout;
    private Long discoveryInitialWaitTimeout;
    private String clientID;
    private Integer dupsOKBatchSize;
    private Integer transactionBatchSize;
    private Long clientFailureCheckPeriod;
    private Long connectionTTL;
    private Boolean cacheLargeMessagesClient;
    private Long callTimeout;
    private Long callFailoverTimeout;
    private Boolean compressLargeMessage;
    private Integer consumerWindowSize;
    private Integer producerWindowSize;
    private Integer consumerMaxRate;
    private Integer confirmationWindowSize;
    private Boolean failoverOnInitialConnection;
    private Integer producerMaxRate;
    private Integer minLargeMessageSize;
    private Boolean blockOnAcknowledge;
    private Boolean blockOnNonDurableSend;
    private Boolean blockOnDurableSend;
    private Boolean autoGroup;
    private Boolean preAcknowledge;
    private Integer initialConnectAttempts;
    private Long retryInterval;
    private Double retryIntervalMultiplier;
    private Long maxRetryInterval;
    private Integer reconnectAttempts;
    private Boolean useGlobalPools;
    private Boolean cacheDestinations;
    private Integer initialMessagePacketSize;
    private Integer scheduledThreadPoolMaxSize;
    private Integer threadPoolMaxSize;
    private String groupID;
    private String protocolManagerFactoryStr;
    private String deserializationBlackList;
    private String deserializationWhiteList;

    public List<String> getParsedConnectorClassNames() {
        return this.connectorClassName;
    }

    public List<Map<String, Object>> getParsedConnectionParameters() {
        return this.connectionParameters;
    }

    public void setParsedConnectionParameters(List<Map<String, Object>> connectionParameters) {
        this.connectionParameters = connectionParameters;
        this.hasBeenUpdated = true;
    }

    public void setParsedConnectorClassNames(List<String> value) {
        this.connectorClassName = value;
        this.hasBeenUpdated = true;
    }

    public Boolean isHA() {
        return this.ha;
    }

    public void setHA(Boolean ha) {
        this.hasBeenUpdated = true;
        this.ha = ha;
    }

    public Boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        this.hasBeenUpdated = true;
        this.cacheLargeMessagesClient = cacheLargeMessagesClient;
    }

    public Boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        this.hasBeenUpdated = true;
        this.compressLargeMessage = compressLargeMessage;
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConnectionLoadBalancingPolicyClassName()");
        }
        return this.connectionLoadBalancingPolicyClassName;
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setSessionDefaultType(" + connectionLoadBalancingPolicyClassName + ")");
        }
        this.hasBeenUpdated = true;
        this.connectionLoadBalancingPolicyClassName = connectionLoadBalancingPolicyClassName;
    }

    public String getDiscoveryAddress() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryAddress()");
        }
        return this.discoveryAddress;
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryAddress(" + discoveryAddress + ")");
        }
        this.hasBeenUpdated = true;
        this.discoveryAddress = discoveryAddress;
    }

    public Integer getDiscoveryPort() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryPort()");
        }
        return this.discoveryPort;
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryLocalBindAddress(" + discoveryLocalBindAddress + ")");
        }
        this.hasBeenUpdated = true;
        this.discoveryLocalBindAddress = discoveryLocalBindAddress;
    }

    public String getDiscoveryLocalBindAddress() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryLocalBindAddress()");
        }
        return this.discoveryLocalBindAddress;
    }

    public void setDiscoveryPort(Integer discoveryPort) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryPort(" + discoveryPort + ")");
        }
        this.hasBeenUpdated = true;
        this.discoveryPort = discoveryPort;
    }

    public Long getDiscoveryRefreshTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryRefreshTimeout()");
        }
        return this.discoveryRefreshTimeout;
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")");
        }
        this.hasBeenUpdated = true;
        this.discoveryRefreshTimeout = discoveryRefreshTimeout;
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDiscoveryInitialWaitTimeout()");
        }
        return this.discoveryInitialWaitTimeout;
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")");
        }
        this.hasBeenUpdated = true;
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
    }

    public String getClientID() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientID()");
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientID(" + clientID + ")");
        }
        this.hasBeenUpdated = true;
        this.clientID = clientID;
    }

    public Integer getDupsOKBatchSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getDupsOKBatchSize()");
        }
        return this.dupsOKBatchSize;
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setDupsOKBatchSize(" + dupsOKBatchSize + ")");
        }
        this.hasBeenUpdated = true;
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public Integer getTransactionBatchSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getTransactionBatchSize()");
        }
        return this.transactionBatchSize;
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setTransactionBatchSize(" + transactionBatchSize + ")");
        }
        this.hasBeenUpdated = true;
        this.transactionBatchSize = transactionBatchSize;
    }

    public Long getClientFailureCheckPeriod() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getClientFailureCheckPeriod()");
        }
        return this.clientFailureCheckPeriod;
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")");
        }
        this.hasBeenUpdated = true;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    public Long getConnectionTTL() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConnectionTTL()");
        }
        return this.connectionTTL;
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConnectionTTL(" + connectionTTL + ")");
        }
        this.hasBeenUpdated = true;
        this.connectionTTL = connectionTTL;
    }

    public Long getCallTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getCallTimeout()");
        }
        return this.callTimeout;
    }

    public void setCallTimeout(Long callTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCallTimeout(" + callTimeout + ")");
        }
        this.hasBeenUpdated = true;
        this.callTimeout = callTimeout;
    }

    public Long getCallFailoverTimeout() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getCallFailoverTimeout()");
        }
        return this.callFailoverTimeout;
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCallFailoverTimeout(" + callFailoverTimeout + ")");
        }
        this.hasBeenUpdated = true;
        this.callFailoverTimeout = callFailoverTimeout;
    }

    public Integer getConsumerWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConsumerWindowSize()");
        }
        return this.consumerWindowSize;
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConsumerWindowSize(" + consumerWindowSize + ")");
        }
        this.hasBeenUpdated = true;
        this.consumerWindowSize = consumerWindowSize;
    }

    public Integer getConsumerMaxRate() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConsumerMaxRate()");
        }
        return this.consumerMaxRate;
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConsumerMaxRate(" + consumerMaxRate + ")");
        }
        this.hasBeenUpdated = true;
        this.consumerMaxRate = consumerMaxRate;
    }

    public Integer getConfirmationWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getConfirmationWindowSize()");
        }
        return this.confirmationWindowSize;
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setConfirmationWindowSize(" + confirmationWindowSize + ")");
        }
        this.hasBeenUpdated = true;
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public Boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
        this.hasBeenUpdated = true;
        this.failoverOnInitialConnection = failoverOnInitialConnection;
    }

    public Integer getProducerMaxRate() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getProducerMaxRate()");
        }
        return this.producerMaxRate;
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setProducerMaxRate(" + producerMaxRate + ")");
        }
        this.hasBeenUpdated = true;
        this.producerMaxRate = producerMaxRate;
    }

    public Integer getProducerWindowSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getProducerWindowSize()");
        }
        return this.producerWindowSize;
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setProducerWindowSize(" + producerWindowSize + ")");
        }
        this.hasBeenUpdated = true;
        this.producerWindowSize = producerWindowSize;
    }

    public Integer getMinLargeMessageSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMinLargeMessageSize()");
        }
        return this.minLargeMessageSize;
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setMinLargeMessageSize(" + minLargeMessageSize + ")");
        }
        this.hasBeenUpdated = true;
        this.minLargeMessageSize = minLargeMessageSize;
    }

    public Boolean isBlockOnAcknowledge() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isBlockOnAcknowledge()");
        }
        return this.blockOnAcknowledge;
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnAcknowledge(" + blockOnAcknowledge + ")");
        }
        this.hasBeenUpdated = true;
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    public Boolean isBlockOnNonDurableSend() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isBlockOnNonDurableSend()");
        }
        return this.blockOnNonDurableSend;
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnNonDurableSend(" + blockOnNonDurableSend + ")");
        }
        this.hasBeenUpdated = true;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    public Boolean isBlockOnDurableSend() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isBlockOnDurableSend()");
        }
        return this.blockOnDurableSend;
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setBlockOnDurableSend(" + blockOnDurableSend + ")");
        }
        this.hasBeenUpdated = true;
        this.blockOnDurableSend = blockOnDurableSend;
    }

    public Boolean isAutoGroup() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isAutoGroup()");
        }
        return this.autoGroup;
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setAutoGroup(" + autoGroup + ")");
        }
        this.hasBeenUpdated = true;
        this.autoGroup = autoGroup;
    }

    public Boolean isPreAcknowledge() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isPreAcknowledge()");
        }
        return this.preAcknowledge;
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setPreAcknowledge(" + preAcknowledge + ")");
        }
        this.hasBeenUpdated = true;
        this.preAcknowledge = preAcknowledge;
    }

    public Long getRetryInterval() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getRetryInterval()");
        }
        return this.retryInterval;
    }

    public void setRetryInterval(Long retryInterval) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setRetryInterval(" + retryInterval + ")");
        }
        this.hasBeenUpdated = true;
        this.retryInterval = retryInterval;
    }

    public Double getRetryIntervalMultiplier() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getRetryIntervalMultiplier()");
        }
        return this.retryIntervalMultiplier;
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")");
        }
        this.hasBeenUpdated = true;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public Long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        this.hasBeenUpdated = true;
        this.maxRetryInterval = maxRetryInterval;
    }

    public Integer getReconnectAttempts() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getReconnectAttempts()");
        }
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setReconnectAttempts(" + reconnectAttempts + ")");
        }
        this.hasBeenUpdated = true;
        this.reconnectAttempts = reconnectAttempts;
    }

    public Boolean isUseGlobalPools() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isUseGlobalPools()");
        }
        return this.useGlobalPools;
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setUseGlobalPools(" + useGlobalPools + ")");
        }
        this.hasBeenUpdated = true;
        this.useGlobalPools = useGlobalPools;
    }

    public Boolean isCacheDestinations() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isCacheDestinations()");
        }
        return this.cacheDestinations;
    }

    public void setCacheDestinations(Boolean cacheDestinations) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setCacheDestinations(" + cacheDestinations + ")");
        }
        this.hasBeenUpdated = true;
        this.cacheDestinations = cacheDestinations;
    }

    public Integer getScheduledThreadPoolMaxSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getScheduledThreadPoolMaxSize()");
        }
        return this.scheduledThreadPoolMaxSize;
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setScheduledThreadPoolMaxSize(" + scheduledThreadPoolMaxSize + ")");
        }
        this.hasBeenUpdated = true;
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    public Integer getThreadPoolMaxSize() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getThreadPoolMaxSize()");
        }
        return this.threadPoolMaxSize;
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setThreadPoolMaxSize(" + threadPoolMaxSize + ")");
        }
        this.hasBeenUpdated = true;
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.hasBeenUpdated = true;
        this.groupID = groupID;
    }

    public Integer getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        this.hasBeenUpdated = true;
        this.initialConnectAttempts = initialConnectAttempts;
    }

    public Integer getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        this.hasBeenUpdated = true;
        this.initialMessagePacketSize = initialMessagePacketSize;
    }

    public String getJgroupsFile() {
        return this.jgroupsFile;
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.jgroupsFile = jgroupsFile;
        this.hasBeenUpdated = true;
    }

    public String getJgroupsChannelName() {
        return this.jgroupsChannelName;
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.jgroupsChannelName = jgroupsChannelName;
        this.hasBeenUpdated = true;
    }

    public String getProtocolManagerFactoryStr() {
        return this.protocolManagerFactoryStr;
    }

    public void setProtocolManagerFactoryStr(String protocolManagerFactoryStr) {
        this.protocolManagerFactoryStr = protocolManagerFactoryStr;
    }

    public String getDeserializationBlackList() {
        return this.deserializationBlackList;
    }

    public void setDeserializationBlackList(String deserializationBlackList) {
        this.deserializationBlackList = deserializationBlackList;
        this.hasBeenUpdated = true;
    }

    public String getDeserializationWhiteList() {
        return this.deserializationWhiteList;
    }

    public void setDeserializationWhiteList(String deserializationWhiteList) {
        this.deserializationWhiteList = deserializationWhiteList;
        this.hasBeenUpdated = true;
    }

    public boolean isHasBeenUpdated() {
        return this.hasBeenUpdated;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionFactoryProperties other = (ConnectionFactoryProperties)obj;
        if (this.autoGroup == null ? other.autoGroup != null : !this.autoGroup.equals(other.autoGroup)) {
            return false;
        }
        if (this.blockOnAcknowledge == null ? other.blockOnAcknowledge != null : !this.blockOnAcknowledge.equals(other.blockOnAcknowledge)) {
            return false;
        }
        if (this.blockOnDurableSend == null ? other.blockOnDurableSend != null : !this.blockOnDurableSend.equals(other.blockOnDurableSend)) {
            return false;
        }
        if (this.blockOnNonDurableSend == null ? other.blockOnNonDurableSend != null : !this.blockOnNonDurableSend.equals(other.blockOnNonDurableSend)) {
            return false;
        }
        if (this.cacheLargeMessagesClient == null ? other.cacheLargeMessagesClient != null : !this.cacheLargeMessagesClient.equals(other.cacheLargeMessagesClient)) {
            return false;
        }
        if (this.compressLargeMessage == null ? other.compressLargeMessage != null : !this.compressLargeMessage.equals(other.compressLargeMessage)) {
            return false;
        }
        if (this.failoverOnInitialConnection == null ? other.failoverOnInitialConnection != null : !this.failoverOnInitialConnection.equals(other.failoverOnInitialConnection)) {
            return false;
        }
        if (this.ha == null ? other.ha != null : !this.ha.equals(other.ha)) {
            return false;
        }
        if (this.preAcknowledge == null ? other.preAcknowledge != null : !this.preAcknowledge.equals(other.preAcknowledge)) {
            return false;
        }
        if (this.callFailoverTimeout == null ? other.callFailoverTimeout != null : !this.callFailoverTimeout.equals(other.callFailoverTimeout)) {
            return false;
        }
        if (this.callTimeout == null ? other.callTimeout != null : !this.callTimeout.equals(other.callTimeout)) {
            return false;
        }
        if (this.clientFailureCheckPeriod == null ? other.clientFailureCheckPeriod != null : !this.clientFailureCheckPeriod.equals(other.clientFailureCheckPeriod)) {
            return false;
        }
        if (this.clientID == null ? other.clientID != null : !this.clientID.equals(other.clientID)) {
            return false;
        }
        if (this.confirmationWindowSize == null ? other.confirmationWindowSize != null : !this.confirmationWindowSize.equals(other.confirmationWindowSize)) {
            return false;
        }
        if (this.connectionLoadBalancingPolicyClassName == null ? other.connectionLoadBalancingPolicyClassName != null : !this.connectionLoadBalancingPolicyClassName.equals(other.connectionLoadBalancingPolicyClassName)) {
            return false;
        }
        if (this.connectionTTL == null ? other.connectionTTL != null : !this.connectionTTL.equals(other.connectionTTL)) {
            return false;
        }
        if (this.consumerMaxRate == null ? other.consumerMaxRate != null : !this.consumerMaxRate.equals(other.consumerMaxRate)) {
            return false;
        }
        if (this.consumerWindowSize == null ? other.consumerWindowSize != null : !this.consumerWindowSize.equals(other.consumerWindowSize)) {
            return false;
        }
        if (this.discoveryAddress == null ? other.discoveryAddress != null : !this.discoveryAddress.equals(other.discoveryAddress)) {
            return false;
        }
        if (this.discoveryInitialWaitTimeout == null ? other.discoveryInitialWaitTimeout != null : !this.discoveryInitialWaitTimeout.equals(other.discoveryInitialWaitTimeout)) {
            return false;
        }
        if (this.discoveryLocalBindAddress == null ? other.discoveryLocalBindAddress != null : !this.discoveryLocalBindAddress.equals(other.discoveryLocalBindAddress)) {
            return false;
        }
        if (this.discoveryPort == null ? other.discoveryPort != null : !this.discoveryPort.equals(other.discoveryPort)) {
            return false;
        }
        if (this.discoveryRefreshTimeout == null ? other.discoveryRefreshTimeout != null : !this.discoveryRefreshTimeout.equals(other.discoveryRefreshTimeout)) {
            return false;
        }
        if (this.dupsOKBatchSize == null ? other.dupsOKBatchSize != null : !this.dupsOKBatchSize.equals(other.dupsOKBatchSize)) {
            return false;
        }
        if (this.groupID == null ? other.groupID != null : !this.groupID.equals(other.groupID)) {
            return false;
        }
        if (this.initialConnectAttempts == null ? other.initialConnectAttempts != null : !this.initialConnectAttempts.equals(other.initialConnectAttempts)) {
            return false;
        }
        if (this.initialMessagePacketSize == null ? other.initialMessagePacketSize != null : !this.initialMessagePacketSize.equals(other.initialMessagePacketSize)) {
            return false;
        }
        if (this.jgroupsChannelName == null ? other.jgroupsChannelName != null : !this.jgroupsChannelName.equals(other.jgroupsChannelName)) {
            return false;
        }
        if (this.jgroupsFile == null ? other.jgroupsFile != null : !this.jgroupsFile.equals(other.jgroupsFile)) {
            return false;
        }
        if (this.maxRetryInterval == null ? other.maxRetryInterval != null : !this.maxRetryInterval.equals(other.maxRetryInterval)) {
            return false;
        }
        if (this.minLargeMessageSize == null ? other.minLargeMessageSize != null : !this.minLargeMessageSize.equals(other.minLargeMessageSize)) {
            return false;
        }
        if (this.producerMaxRate == null ? other.producerMaxRate != null : !this.producerMaxRate.equals(other.producerMaxRate)) {
            return false;
        }
        if (this.producerWindowSize == null) {
            if (other.producerWindowSize != null) {
                return false;
            }
        } else {
            if (!this.producerWindowSize.equals(other.producerWindowSize)) {
                return false;
            }
            if (!this.protocolManagerFactoryStr.equals(other.protocolManagerFactoryStr)) {
                return false;
            }
        }
        if (this.protocolManagerFactoryStr == null && other.protocolManagerFactoryStr != null) {
            return false;
        }
        if (this.reconnectAttempts == null ? other.reconnectAttempts != null : !this.reconnectAttempts.equals(other.reconnectAttempts)) {
            return false;
        }
        if (this.retryInterval == null ? other.retryInterval != null : !this.retryInterval.equals(other.retryInterval)) {
            return false;
        }
        if (this.retryIntervalMultiplier == null ? other.retryIntervalMultiplier != null : !this.retryIntervalMultiplier.equals(other.retryIntervalMultiplier)) {
            return false;
        }
        if (this.scheduledThreadPoolMaxSize == null ? other.scheduledThreadPoolMaxSize != null : !this.scheduledThreadPoolMaxSize.equals(other.scheduledThreadPoolMaxSize)) {
            return false;
        }
        if (this.threadPoolMaxSize == null ? other.threadPoolMaxSize != null : !this.threadPoolMaxSize.equals(other.threadPoolMaxSize)) {
            return false;
        }
        if (this.transactionBatchSize == null ? other.transactionBatchSize != null : !this.transactionBatchSize.equals(other.transactionBatchSize)) {
            return false;
        }
        if (this.useGlobalPools == null ? other.useGlobalPools != null : !this.useGlobalPools.equals(other.useGlobalPools)) {
            return false;
        }
        if (this.connectorClassName == null ? other.connectorClassName != null : !this.connectorClassName.equals(other.connectorClassName)) {
            return false;
        }
        if (this.connectionParameters == null ? other.connectionParameters != null : !this.connectionParameters.equals(other.connectionParameters)) {
            return false;
        }
        if (this.deserializationBlackList == null ? other.deserializationBlackList != null : !this.deserializationBlackList.equals(other.deserializationBlackList)) {
            return false;
        }
        return !(this.deserializationWhiteList == null ? other.deserializationWhiteList != null : !this.deserializationWhiteList.equals(other.deserializationWhiteList));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ha == null ? 0 : this.ha.hashCode());
        result = 31 * result + (this.connectionLoadBalancingPolicyClassName == null ? 0 : this.connectionLoadBalancingPolicyClassName.hashCode());
        result = 31 * result + (this.jgroupsFile == null ? 0 : this.jgroupsFile.hashCode());
        result = 31 * result + (this.jgroupsChannelName == null ? 0 : this.jgroupsChannelName.hashCode());
        result = 31 * result + (this.discoveryAddress == null ? 0 : this.discoveryAddress.hashCode());
        result = 31 * result + (this.discoveryPort == null ? 0 : this.discoveryPort.hashCode());
        result = 31 * result + (this.discoveryLocalBindAddress == null ? 0 : this.discoveryLocalBindAddress.hashCode());
        result = 31 * result + (this.discoveryRefreshTimeout == null ? 0 : this.discoveryRefreshTimeout.hashCode());
        result = 31 * result + (this.discoveryInitialWaitTimeout == null ? 0 : this.discoveryInitialWaitTimeout.hashCode());
        result = 31 * result + (this.clientID == null ? 0 : this.clientID.hashCode());
        result = 31 * result + (this.dupsOKBatchSize == null ? 0 : this.dupsOKBatchSize.hashCode());
        result = 31 * result + (this.transactionBatchSize == null ? 0 : this.transactionBatchSize.hashCode());
        result = 31 * result + (this.clientFailureCheckPeriod == null ? 0 : this.clientFailureCheckPeriod.hashCode());
        result = 31 * result + (this.connectionTTL == null ? 0 : this.connectionTTL.hashCode());
        result = 31 * result + (this.cacheLargeMessagesClient == null ? 0 : this.cacheLargeMessagesClient.hashCode());
        result = 31 * result + (this.callTimeout == null ? 0 : this.callTimeout.hashCode());
        result = 31 * result + (this.callFailoverTimeout == null ? 0 : this.callFailoverTimeout.hashCode());
        result = 31 * result + (this.compressLargeMessage == null ? 0 : this.compressLargeMessage.hashCode());
        result = 31 * result + (this.consumerWindowSize == null ? 0 : this.consumerWindowSize.hashCode());
        result = 31 * result + (this.producerWindowSize == null ? 0 : this.producerWindowSize.hashCode());
        result = 31 * result + (this.protocolManagerFactoryStr == null ? 0 : this.protocolManagerFactoryStr.hashCode());
        result = 31 * result + (this.consumerMaxRate == null ? 0 : this.consumerMaxRate.hashCode());
        result = 31 * result + (this.confirmationWindowSize == null ? 0 : this.confirmationWindowSize.hashCode());
        result = 31 * result + (this.failoverOnInitialConnection == null ? 0 : this.failoverOnInitialConnection.hashCode());
        result = 31 * result + (this.producerMaxRate == null ? 0 : this.producerMaxRate.hashCode());
        result = 31 * result + (this.minLargeMessageSize == null ? 0 : this.minLargeMessageSize.hashCode());
        result = 31 * result + (this.blockOnAcknowledge == null ? 0 : this.blockOnAcknowledge.hashCode());
        result = 31 * result + (this.blockOnNonDurableSend == null ? 0 : this.blockOnNonDurableSend.hashCode());
        result = 31 * result + (this.blockOnDurableSend == null ? 0 : this.blockOnDurableSend.hashCode());
        result = 31 * result + (this.autoGroup == null ? 0 : this.autoGroup.hashCode());
        result = 31 * result + (this.preAcknowledge == null ? 0 : this.preAcknowledge.hashCode());
        result = 31 * result + (this.initialConnectAttempts == null ? 0 : this.initialConnectAttempts.hashCode());
        result = 31 * result + (this.retryInterval == null ? 0 : this.retryInterval.hashCode());
        result = 31 * result + (this.retryIntervalMultiplier == null ? 0 : this.retryIntervalMultiplier.hashCode());
        result = 31 * result + (this.maxRetryInterval == null ? 0 : this.maxRetryInterval.hashCode());
        result = 31 * result + (this.reconnectAttempts == null ? 0 : this.reconnectAttempts.hashCode());
        result = 31 * result + (this.useGlobalPools == null ? 0 : this.useGlobalPools.hashCode());
        result = 31 * result + (this.initialMessagePacketSize == null ? 0 : this.initialMessagePacketSize.hashCode());
        result = 31 * result + (this.scheduledThreadPoolMaxSize == null ? 0 : this.scheduledThreadPoolMaxSize.hashCode());
        result = 31 * result + (this.threadPoolMaxSize == null ? 0 : this.threadPoolMaxSize.hashCode());
        result = 31 * result + (this.groupID == null ? 0 : this.groupID.hashCode());
        result = 31 * result + (this.connectorClassName == null ? 0 : this.connectorClassName.hashCode());
        result = 31 * result + (this.connectionParameters == null ? 0 : this.connectionParameters.hashCode());
        result = 31 * result + (this.deserializationBlackList == null ? 0 : this.deserializationBlackList.hashCode());
        result = 31 * result + (this.deserializationWhiteList == null ? 0 : this.deserializationWhiteList.hashCode());
        return result;
    }
}

