/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.util;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.util.ByteSequence;

public class OpenWireUtil {
    public static final WildcardConfiguration OPENWIRE_WILDCARD = new OpenWireWildcardConfiguration();

    public static ActiveMQBuffer toActiveMQBuffer(ByteSequence bytes) {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)bytes.length);
        buffer.writeBytes(bytes.data, bytes.offset, bytes.length);
        return buffer;
    }

    public static ActiveMQDestination toAMQAddress(Message message, ActiveMQDestination actualDestination) {
        String address;
        String strippedAddress = address = message.getAddress();
        if (address == null) {
            return actualDestination;
        }
        if (actualDestination.isQueue()) {
            return new ActiveMQQueue(strippedAddress);
        }
        return new ActiveMQTopic(strippedAddress);
    }

    public static XidImpl toXID(TransactionId xaXid) {
        return OpenWireUtil.toXID((XATransactionId)xaXid);
    }

    public static XidImpl toXID(XATransactionId xaXid) {
        return new XidImpl(xaXid.getBranchQualifier(), xaXid.getFormatId(), xaXid.getGlobalTransactionId());
    }

    public static class OpenWireWildcardConfiguration
    extends WildcardConfiguration {
        public OpenWireWildcardConfiguration() {
            this.setDelimiter('.');
            this.setSingleWord('*');
            this.setAnyWords('>');
        }
    }
}

