/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.InvalidDestinationException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManager;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.jboss.logging.Logger;

public class AMQSession
implements SessionCallback {
    private final Logger logger = Logger.getLogger(AMQSession.class);
    protected final IDGenerator consumerIDGenerator = new SimpleIDGenerator(0L);
    private ConnectionInfo connInfo;
    private ServerSession coreSession;
    private SessionInfo sessInfo;
    private ActiveMQServer server;
    private OpenWireConnection connection;
    private AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledPool;
    private final OpenWireMessageConverter converter;
    private final OpenWireProtocolManager protocolManager;

    public AMQSession(ConnectionInfo connInfo, SessionInfo sessInfo, ActiveMQServer server, OpenWireConnection connection, OpenWireProtocolManager protocolManager) {
        this.connInfo = connInfo;
        this.sessInfo = sessInfo;
        this.server = server;
        this.connection = connection;
        this.protocolManager = protocolManager;
        this.scheduledPool = protocolManager.getScheduledPool();
        OpenWireFormat marshaller = (OpenWireFormat)connection.getMarshaller();
        this.converter = new OpenWireMessageConverter((WireFormat)marshaller.copy());
    }

    public boolean isClosed() {
        return this.coreSession.isClosed();
    }

    public OpenWireMessageConverter getConverter() {
        return this.protocolManager.getInternalConverter();
    }

    public void initialize() {
        String name = this.sessInfo.getSessionId().toString();
        String username = this.connInfo.getUserName();
        String password = this.connInfo.getPassword();
        int minLargeMessageSize = Integer.MAX_VALUE;
        try {
            this.coreSession = this.server.createSession(name, username, password, minLargeMessageSize, (RemotingConnection)this.connection, true, false, false, false, null, (SessionCallback)this, true, this.connection.getOperationContext(), this.protocolManager.getPrefixes());
            long sessionId = this.sessInfo.getSessionId().getValue();
            if (sessionId == -1L) {
                this.connection.setAdvisorySession(this);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.error((Object)"error init session", (Throwable)e);
        }
    }

    public boolean supportsDirectDelivery() {
        return false;
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        if (consumer.getProtocolData() != null) {
            return ((AMQConsumer)consumer.getProtocolData()).updateDeliveryCountAfterCancel(ref);
        }
        return false;
    }

    public List<AMQConsumer> createConsumer(ConsumerInfo info, SlowConsumerDetectionListener slowConsumerDetectionListener) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        ActiveMQDestination[] dests = null;
        dests = dest.isComposite() ? dest.getCompositeDestinations() : new ActiveMQDestination[]{dest};
        LinkedList<AMQConsumer> consumersList = new LinkedList<AMQConsumer>();
        for (ActiveMQDestination openWireDest : dests) {
            SimpleString queueName;
            if (openWireDest.isQueue() && !this.checkAutoCreateQueue(queueName = new SimpleString(this.convertWildcard(openWireDest.getPhysicalName())), openWireDest.isTemporary())) {
                throw new InvalidDestinationException("Destination doesn't exist: " + queueName);
            }
            AMQConsumer consumer = new AMQConsumer(this, openWireDest, info, this.scheduledPool);
            long nativeID = this.consumerIDGenerator.generateID();
            consumer.init(slowConsumerDetectionListener, nativeID);
            consumersList.add(consumer);
        }
        return consumersList;
    }

    private boolean checkAutoCreateQueue(SimpleString queueName, boolean isTemporary) throws Exception {
        boolean hasQueue = true;
        if (!this.connection.containsKnownDestination(queueName)) {
            BindingQueryResult bindingQuery = this.server.bindingQuery(queueName);
            QueueQueryResult queueBinding = this.server.queueQuery(queueName);
            try {
                if (!queueBinding.isExists()) {
                    if (bindingQuery.isAutoCreateQueues()) {
                        this.server.createQueue(queueName, RoutingType.ANYCAST, queueName, null, true, isTemporary);
                        this.connection.addKnownDestination(queueName);
                    } else {
                        hasQueue = false;
                    }
                }
            }
            catch (ActiveMQQueueExistsException e) {
                hasQueue = true;
            }
        }
        return hasQueue;
    }

    public void start() {
        this.coreSession.start();
        this.started.set(true);
    }

    public void afterDelivery() throws Exception {
    }

    public void browserFinished(ServerConsumer consumer) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        if (theConsumer != null) {
            theConsumer.browseFinished();
        }
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        return this.connection.isWritable(callback);
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public int sendMessage(MessageReference reference, Message message, ServerConsumer consumer, int deliveryCount) {
        AMQConsumer theConsumer = (AMQConsumer)consumer.getProtocolData();
        return theConsumer.handleDeliver(reference, message.toCore(), deliveryCount);
    }

    public int sendLargeMessage(MessageReference reference, Message message, ServerConsumer consumerID, long bodySize, int deliveryCount) {
        return 0;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public void closed() {
    }

    public boolean hasCredits(ServerConsumer consumer) {
        AMQConsumer amqConsumer = null;
        if (consumer.getProtocolData() != null) {
            amqConsumer = (AMQConsumer)consumer.getProtocolData();
        }
        return amqConsumer != null && amqConsumer.hasCredits();
    }

    public void disconnect(ServerConsumer consumerId, String queueName) {
    }

    public void send(ProducerInfo producerInfo, org.apache.activemq.command.Message messageSend, boolean sendProducerAck) throws Exception {
        messageSend.setBrokerInTime(System.currentTimeMillis());
        ActiveMQDestination destination = messageSend.getDestination();
        ActiveMQDestination[] actualDestinations = null;
        if (destination.isComposite()) {
            actualDestinations = destination.getCompositeDestinations();
            messageSend.setOriginalDestination(destination);
        } else {
            actualDestinations = new ActiveMQDestination[]{destination};
        }
        Message originalCoreMsg = this.getConverter().inbound(messageSend);
        if (this.connection.isNoLocal()) {
            originalCoreMsg.putStringProperty(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString(), this.connection.getState().getInfo().getConnectionId().getValue());
        }
        if (this.connection.getContext().isFaultTolerant() && !messageSend.getProperties().containsKey(Message.HDR_DUPLICATE_DETECTION_ID.toString())) {
            originalCoreMsg.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID.toString(), messageSend.getMessageId().toString());
        }
        boolean shouldBlockProducer = producerInfo.getWindowSize() > 0 || messageSend.isResponseRequired();
        AtomicInteger count = new AtomicInteger(actualDestinations.length);
        if (shouldBlockProducer) {
            this.connection.getContext().setDontSendReponse(true);
        }
        for (int i = 0; i < actualDestinations.length; ++i) {
            ActiveMQDestination dest = actualDestinations[i];
            SimpleString address = new SimpleString(dest.getPhysicalName());
            Message coreMsg = originalCoreMsg.copy();
            coreMsg.setAddress(address);
            if (actualDestinations[i].isQueue()) {
                this.checkAutoCreateQueue(new SimpleString(actualDestinations[i].getPhysicalName()), actualDestinations[i].isTemporary());
                coreMsg.setRoutingType(RoutingType.ANYCAST);
            } else {
                coreMsg.setRoutingType(RoutingType.MULTICAST);
            }
            PagingStore store = this.server.getPagingManager().getPageStore(address);
            this.connection.disableTtl();
            if (shouldBlockProducer) {
                if (store.checkMemory(() -> {
                    Exception exceptionToSend = null;
                    try {
                        RoutingStatus result = this.getCoreSession().send(coreMsg, false, dest.isTemporary());
                        if (result == RoutingStatus.NO_BINDINGS && dest.isQueue()) {
                            throw new InvalidDestinationException("Cannot publish to a non-existent Destination: " + dest);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)e.getMessage(), (Throwable)e);
                        exceptionToSend = e;
                    }
                    this.connection.enableTtl();
                    if (count.decrementAndGet() == 0) {
                        if (exceptionToSend != null) {
                            this.connection.getContext().setDontSendReponse(false);
                            this.connection.sendException(exceptionToSend);
                        } else if (sendProducerAck) {
                            try {
                                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
                                this.connection.dispatchAsync((Command)ack);
                            }
                            catch (Exception e) {
                                this.connection.getContext().setDontSendReponse(false);
                                ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                                this.connection.sendException(e);
                            }
                        } else {
                            this.connection.getContext().setDontSendReponse(false);
                            try {
                                Response response = new Response();
                                response.setCorrelationId(messageSend.getCommandId());
                                this.connection.dispatchAsync((Command)response);
                            }
                            catch (Exception e) {
                                ActiveMQServerLogger.LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                                this.connection.sendException(e);
                            }
                        }
                    }
                })) continue;
                this.connection.getContext().setDontSendReponse(false);
                this.connection.enableTtl();
                throw new ResourceAllocationException("Queue is full " + address);
            }
            this.connection.getTransportConnection().setAutoRead(false);
            if (!store.checkMemory(() -> {
                this.connection.getTransportConnection().setAutoRead(true);
                this.connection.enableTtl();
            })) {
                this.connection.getTransportConnection().setAutoRead(true);
                this.connection.enableTtl();
                throw new ResourceAllocationException("Queue is full " + address);
            }
            RoutingStatus result = this.getCoreSession().send(coreMsg, false, dest.isTemporary());
            if (result == RoutingStatus.NO_BINDINGS && dest.isQueue()) {
                throw new InvalidDestinationException("Cannot publish to a non-existent Destination: " + dest);
            }
            if (count.decrementAndGet() != 0 || !sendProducerAck) continue;
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
            this.connection.dispatchAsync((Command)ack);
        }
    }

    public String convertWildcard(String physicalName) {
        return OpenWireUtil.OPENWIRE_WILDCARD.convert(physicalName, this.server.getConfiguration().getWildcardConfiguration());
    }

    public ServerSession getCoreSession() {
        return this.coreSession;
    }

    public ActiveMQServer getCoreServer() {
        return this.server;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    public void disableSecurity() {
        this.coreSession.disableSecurity();
    }

    public void deliverMessage(MessageDispatch dispatch) {
        this.connection.deliverMessage(dispatch);
    }

    public void close() throws Exception {
        this.coreSession.close(false);
    }

    public OpenWireConnection getConnection() {
        return this.connection;
    }

    public boolean isInternal() {
        return this.sessInfo.getSessionId().getValue() == -1L;
    }
}

