/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConnectionContext;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.state.ProducerState;

public class AMQProducerBrokerExchange {
    private AMQConnectionContext connectionContext;
    private ProducerState producerState;
    private boolean mutable = true;
    private AtomicLong lastSendSequenceNumber = new AtomicLong(-1L);
    private boolean auditProducerSequenceIds;
    private boolean isNetworkProducer;
    private final FlowControlInfo flowControlInfo = new FlowControlInfo();

    public AMQProducerBrokerExchange copy() {
        AMQProducerBrokerExchange rc = new AMQProducerBrokerExchange();
        rc.connectionContext = this.connectionContext.copy();
        rc.producerState = this.producerState;
        rc.mutable = this.mutable;
        return rc;
    }

    public AMQConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setConnectionContext(AMQConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public ProducerState getProducerState() {
        return this.producerState;
    }

    public void setProducerState(ProducerState producerState) {
        this.producerState = producerState;
    }

    public boolean canDispatch(Message messageSend) {
        boolean canDispatch = true;
        if (this.auditProducerSequenceIds && messageSend.isPersistent()) {
            long producerSequenceId = messageSend.getMessageId().getProducerSequenceId();
            if (this.isNetworkProducer) {
                long lastStoredForMessageProducer = this.getStoredSequenceIdForMessage(messageSend.getMessageId());
                if (producerSequenceId <= lastStoredForMessageProducer) {
                    canDispatch = false;
                }
            } else if (producerSequenceId <= this.lastSendSequenceNumber.get()) {
                canDispatch = false;
                if (messageSend.isInTransaction()) {
                    // empty if block
                }
            } else {
                this.lastSendSequenceNumber.set(producerSequenceId);
            }
        }
        return canDispatch;
    }

    private long getStoredSequenceIdForMessage(MessageId messageId) {
        return -1L;
    }

    public void setLastStoredSequenceId(long l) {
    }

    public void incrementSend() {
        this.flowControlInfo.incrementSend();
    }

    public void blockingOnFlowControl(boolean blockingOnFlowControl) {
        this.flowControlInfo.setBlockingOnFlowControl(blockingOnFlowControl);
    }

    public boolean isBlockedForFlowControl() {
        return this.flowControlInfo.isBlockingOnFlowControl();
    }

    public void resetFlowControl() {
        this.flowControlInfo.reset();
    }

    public long getTotalTimeBlocked() {
        return this.flowControlInfo.getTotalTimeBlocked();
    }

    public int getPercentageBlocked() {
        double value = this.flowControlInfo.getSendsBlocked() / this.flowControlInfo.getTotalSends();
        return (int)value * 100;
    }

    public static class FlowControlInfo {
        private AtomicBoolean blockingOnFlowControl = new AtomicBoolean();
        private AtomicLong totalSends = new AtomicLong();
        private AtomicLong sendsBlocked = new AtomicLong();
        private AtomicLong totalTimeBlocked = new AtomicLong();

        public boolean isBlockingOnFlowControl() {
            return this.blockingOnFlowControl.get();
        }

        public void setBlockingOnFlowControl(boolean blockingOnFlowControl) {
            this.blockingOnFlowControl.set(blockingOnFlowControl);
            if (blockingOnFlowControl) {
                this.incrementSendBlocked();
            }
        }

        public long getTotalSends() {
            return this.totalSends.get();
        }

        public void incrementSend() {
            this.totalSends.incrementAndGet();
        }

        public long getSendsBlocked() {
            return this.sendsBlocked.get();
        }

        public void incrementSendBlocked() {
            this.sendsBlocked.incrementAndGet();
        }

        public long getTotalTimeBlocked() {
            return this.totalTimeBlocked.get();
        }

        public void incrementTimeBlocked(long time) {
            this.totalTimeBlocked.addAndGet(time);
        }

        public void reset() {
            this.blockingOnFlowControl.set(false);
            this.totalSends.set(0L);
            this.sendsBlocked.set(0L);
            this.totalTimeBlocked.set(0L);
        }
    }
}

