/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.util.CharsetUtil;
import java.util.UUID;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTFailureListener;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class MQTTConnectionManager {
    private MQTTSession session;
    private MQTTLogger log = MQTTLogger.LOGGER;
    private boolean isWill = false;
    private ByteBuf willMessage;
    private String willTopic;
    private int willQoSLevel;
    private boolean willRetain;

    public MQTTConnectionManager(MQTTSession session) {
        this.session = session;
        MQTTFailureListener failureListener = new MQTTFailureListener(this);
        session.getConnection().addFailureListener(failureListener);
    }

    synchronized void connect(String cId, String username, byte[] passwordInBytes, boolean will, byte[] willMessage, String willTopic, boolean willRetain, int willQosLevel, boolean cleanSession) throws Exception {
        String clientId = this.validateClientId(cId, cleanSession);
        if (clientId == null) {
            this.session.getProtocolHandler().sendConnack(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
            this.session.getProtocolHandler().disconnect(true);
            return;
        }
        this.session.setSessionState(this.getSessionState(clientId));
        String password = passwordInBytes == null ? null : new String(passwordInBytes, CharsetUtil.UTF_8);
        ServerSessionImpl serverSession = this.createServerSession(username, password);
        serverSession.start();
        this.session.setServerSession(serverSession);
        this.session.setIsClean(cleanSession);
        if (will) {
            this.isWill = true;
            this.willMessage = ByteBufAllocator.DEFAULT.buffer(willMessage.length);
            this.willMessage.writeBytes(willMessage);
            this.willQoSLevel = willQosLevel;
            this.willRetain = willRetain;
            this.willTopic = willTopic;
        }
        this.session.getConnection().setConnected(true);
        this.session.start();
        this.session.getConnection().setClientID(clientId);
        this.session.getProtocolHandler().sendConnack(MqttConnectReturnCode.CONNECTION_ACCEPTED);
    }

    ServerSessionImpl createServerSession(String username, String password) throws Exception {
        String id = UUIDGenerator.getInstance().generateStringUUID();
        ActiveMQServer server = this.session.getServer();
        ServerSession serverSession = server.createSession(id, username, password, 102400, (RemotingConnection)this.session.getConnection(), true, true, false, false, null, this.session.getSessionCallback(), false, server.newOperationContext(), this.session.getProtocolManager().getPrefixes());
        return (ServerSessionImpl)serverSession;
    }

    synchronized void disconnect(boolean failure) {
        if (this.session == null || this.session.getStopped()) {
            return;
        }
        try {
            if (this.isWill && failure) {
                this.session.getMqttPublishManager().sendInternal(0, this.willTopic, this.willQoSLevel, this.willMessage, this.willRetain, true);
            }
            this.session.stop();
            this.session.getConnection().destroy();
        }
        catch (Exception e) {
            this.log.error("Error disconnecting client: " + e.getMessage());
        }
        finally {
            if (this.session.getSessionState() != null) {
                this.session.getSessionState().setAttached(false);
                String clientId = this.session.getSessionState().getClientId();
                if (clientId != null && this.session.getProtocolManager().isClientConnected(clientId, this.session.getConnection())) {
                    this.session.getProtocolManager().removeConnectedClient(clientId);
                }
            }
        }
    }

    private MQTTSessionState getSessionState(String clientId) throws InterruptedException {
        MQTTSessionState state = MQTTSession.SESSIONS.get(clientId);
        if (state != null) {
            return state;
        }
        state = new MQTTSessionState(clientId);
        MQTTSession.SESSIONS.put(clientId, state);
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String validateClientId(String clientId, boolean cleanSession) {
        if (clientId == null || clientId.isEmpty()) {
            if (!cleanSession) return null;
            return UUID.randomUUID().toString();
        }
        MQTTConnection connection = this.session.getProtocolManager().addConnectedClient(clientId, this.session.getConnection());
        if (connection == null) return clientId;
        connection.disconnect(false);
        return clientId;
    }
}

