/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTMessageInfo;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSessionState {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final MQTTSessionState DEFAULT = new MQTTSessionState((String)null);
    private MQTTSession session;
    private final String clientId;
    private final ConcurrentMap<String, Pair<MqttTopicSubscription, Integer>> subscriptions = new ConcurrentHashMap<String, Pair<MqttTopicSubscription, Integer>>();
    private final Map<Integer, MQTTMessageInfo> messageRefStore = new ConcurrentHashMap<Integer, MQTTMessageInfo>();
    private final ConcurrentMap<String, Map<Long, Integer>> addressMessageMap = new ConcurrentHashMap<String, Map<Long, Integer>>();
    private final Set<Integer> pubRec = new HashSet<Integer>();
    private boolean attached = false;
    private long disconnectedTime = 0L;
    private final OutboundStore outboundStore = new OutboundStore();
    private int clientSessionExpiryInterval;
    private boolean isWill = false;
    private ByteBuf willMessage;
    private String willTopic;
    private int willQoSLevel;
    private boolean willRetain = false;
    private long willDelayInterval = 0L;
    private List<? extends MqttProperties.MqttProperty> willUserProperties;
    private WillStatus willStatus = WillStatus.NOT_SENT;
    private boolean failed = false;
    private int clientMaxPacketSize = 0;
    private Map<Integer, String> clientTopicAliases;
    private Integer clientTopicAliasMaximum;
    private Map<String, Integer> serverTopicAliases;

    public MQTTSessionState(String clientId) {
        this.clientId = clientId;
    }

    public MQTTSessionState(CoreMessage message) {
        logger.debug("Deserializing MQTT session state from {}", (Object)message);
        this.clientId = message.getStringProperty(Message.HDR_LAST_VALUE_NAME);
        ActiveMQBuffer buf = message.getDataBuffer();
        byte version = buf.readByte();
        int subscriptionCount = buf.readInt();
        logger.debug("Deserializing {} subscriptions", (Object)subscriptionCount);
        for (int i = 0; i < subscriptionCount; ++i) {
            String topicName = buf.readString();
            MqttQoS qos = MqttQoS.valueOf((int)buf.readInt());
            boolean nolocal = buf.readBoolean();
            boolean retainAsPublished = buf.readBoolean();
            MqttSubscriptionOption.RetainedHandlingPolicy retainedHandlingPolicy = MqttSubscriptionOption.RetainedHandlingPolicy.valueOf((int)buf.readInt());
            Integer subscriptionId = buf.readNullableInt();
            this.subscriptions.put(topicName, (Pair<MqttTopicSubscription, Integer>)new Pair((Object)new MqttTopicSubscription(topicName, new MqttSubscriptionOption(qos, nolocal, retainAsPublished, retainedHandlingPolicy)), (Object)subscriptionId));
        }
    }

    public MQTTSession getSession() {
        return this.session;
    }

    public void setSession(MQTTSession session) {
        this.session = session;
    }

    public synchronized void clear() throws Exception {
        this.subscriptions.clear();
        this.messageRefStore.clear();
        this.addressMessageMap.clear();
        this.pubRec.clear();
        this.outboundStore.clear();
        this.disconnectedTime = 0L;
        if (this.willMessage != null) {
            this.willMessage.clear();
            this.willMessage = null;
        }
        this.willStatus = WillStatus.NOT_SENT;
        this.failed = false;
        this.willDelayInterval = 0L;
        this.willRetain = false;
        this.willTopic = null;
        this.clientMaxPacketSize = 0;
        this.clearTopicAliases();
        this.clientTopicAliasMaximum = 0;
    }

    public OutboundStore getOutboundStore() {
        return this.outboundStore;
    }

    public Set<Integer> getPubRec() {
        return this.pubRec;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
    }

    public Collection<MqttTopicSubscription> getSubscriptions() {
        HashSet<MqttTopicSubscription> result = new HashSet<MqttTopicSubscription>();
        for (Pair pair : this.subscriptions.values()) {
            result.add((MqttTopicSubscription)pair.getA());
        }
        return result;
    }

    public Collection<Pair<MqttTopicSubscription, Integer>> getSubscriptionsPlusID() {
        return this.subscriptions.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscription(MqttTopicSubscription subscription, WildcardConfiguration wildcardConfiguration, Integer subscriptionIdentifier) throws Exception {
        ConcurrentMap<String, Pair<MqttTopicSubscription, Integer>> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.addressMessageMap.putIfAbsent(MQTTUtil.getCoreAddressFromMqttTopic(subscription.topicName(), wildcardConfiguration), new ConcurrentHashMap());
            Pair existingSubscription = (Pair)this.subscriptions.get(subscription.topicName());
            if (existingSubscription != null) {
                boolean updated = false;
                if (subscription.qualityOfService().value() > ((MqttTopicSubscription)existingSubscription.getA()).qualityOfService().value()) {
                    existingSubscription.setA((Object)subscription);
                    updated = true;
                }
                if (subscriptionIdentifier != null && !subscriptionIdentifier.equals(existingSubscription.getB())) {
                    existingSubscription.setB((Object)subscriptionIdentifier);
                    updated = true;
                }
                return updated;
            }
            this.subscriptions.put(subscription.topicName(), (Pair<MqttTopicSubscription, Integer>)new Pair((Object)subscription, (Object)subscriptionIdentifier));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(String address) throws Exception {
        ConcurrentMap<String, Pair<MqttTopicSubscription, Integer>> concurrentMap = this.subscriptions;
        synchronized (concurrentMap) {
            this.subscriptions.remove(address);
            this.addressMessageMap.remove(address);
        }
    }

    public MqttTopicSubscription getSubscription(String address) {
        return this.subscriptions.get(address) != null ? (MqttTopicSubscription)((Pair)this.subscriptions.get(address)).getA() : null;
    }

    public Pair<MqttTopicSubscription, Integer> getSubscriptionPlusID(String address) {
        return this.subscriptions.get(address) != null ? (Pair)this.subscriptions.get(address) : null;
    }

    public List<Integer> getMatchingSubscriptionIdentifiers(String address) {
        address = MQTTUtil.getMqttTopicFromCoreAddress(address, this.session.getServer().getConfiguration().getWildcardConfiguration());
        ArrayList<Integer> result = null;
        for (Pair pair : this.subscriptions.values()) {
            Pattern pattern = Match.createPattern((String)((MqttTopicSubscription)pair.getA()).topicName(), (WildcardConfiguration)MQTTUtil.MQTT_WILDCARD, (boolean)true);
            boolean matches = pattern.matcher(address).matches();
            logger.debug("Matching {} with {}: {}", new Object[]{address, pattern, matches});
            if (!matches) continue;
            if (result == null) {
                result = new ArrayList<Integer>();
            }
            if (pair.getB() == null) continue;
            result.add((Integer)pair.getB());
        }
        return result;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(long disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public int getClientSessionExpiryInterval() {
        return this.clientSessionExpiryInterval;
    }

    public void setClientSessionExpiryInterval(int sessionExpiryInterval) {
        this.clientSessionExpiryInterval = sessionExpiryInterval;
    }

    public boolean isWill() {
        return this.isWill;
    }

    public void setWill(boolean will) {
        this.isWill = will;
    }

    public ByteBuf getWillMessage() {
        return this.willMessage;
    }

    public void setWillMessage(ByteBuf willMessage) {
        this.willMessage = willMessage;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public void setWillTopic(String willTopic) {
        this.willTopic = willTopic;
    }

    public int getWillQoSLevel() {
        return this.willQoSLevel;
    }

    public void setWillQoSLevel(int willQoSLevel) {
        this.willQoSLevel = willQoSLevel;
    }

    public boolean isWillRetain() {
        return this.willRetain;
    }

    public void setWillRetain(boolean willRetain) {
        this.willRetain = willRetain;
    }

    public long getWillDelayInterval() {
        return this.willDelayInterval;
    }

    public void setWillDelayInterval(long willDelayInterval) {
        this.willDelayInterval = willDelayInterval;
    }

    public void setWillUserProperties(List<? extends MqttProperties.MqttProperty> userProperties) {
        this.willUserProperties = userProperties;
    }

    public List<? extends MqttProperties.MqttProperty> getWillUserProperties() {
        return this.willUserProperties;
    }

    public WillStatus getWillStatus() {
        return this.willStatus;
    }

    public void setWillStatus(WillStatus willStatus) {
        this.willStatus = willStatus;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public int getClientMaxPacketSize() {
        return this.clientMaxPacketSize;
    }

    public void setClientMaxPacketSize(int clientMaxPacketSize) {
        this.clientMaxPacketSize = clientMaxPacketSize;
    }

    public void putClientTopicAlias(Integer alias, String topicName) {
        if (this.clientTopicAliases == null) {
            this.clientTopicAliases = new HashMap<Integer, String>();
        }
        this.clientTopicAliases.put(alias, topicName);
    }

    public String getClientTopicAlias(Integer alias) {
        String result = this.clientTopicAliases == null ? null : this.clientTopicAliases.get(alias);
        return result;
    }

    public Integer getClientTopicAliasMaximum() {
        return this.clientTopicAliasMaximum;
    }

    public void setClientTopicAliasMaximum(Integer clientTopicAliasMaximum) {
        this.clientTopicAliasMaximum = clientTopicAliasMaximum;
    }

    public Integer addServerTopicAlias(String topicName) {
        Integer alias;
        if (this.serverTopicAliases == null) {
            this.serverTopicAliases = new ConcurrentHashMap<String, Integer>();
        }
        if ((alias = Integer.valueOf(this.serverTopicAliases.size() + 1)) <= this.clientTopicAliasMaximum) {
            this.serverTopicAliases.put(topicName, alias);
            return alias;
        }
        return null;
    }

    public Integer getServerTopicAlias(String topicName) {
        return this.serverTopicAliases == null ? null : this.serverTopicAliases.get(topicName);
    }

    void removeMessageRef(Integer mqttId) {
        Map addressMap;
        MQTTMessageInfo info = this.messageRefStore.remove(mqttId);
        if (info != null && (addressMap = (Map)this.addressMessageMap.get(info.getAddress())) != null) {
            addressMap.remove(info.getServerMessageId());
        }
    }

    public void clearTopicAliases() {
        if (this.clientTopicAliases != null) {
            this.clientTopicAliases.clear();
            this.clientTopicAliases = null;
        }
        if (this.serverTopicAliases != null) {
            this.serverTopicAliases.clear();
            this.serverTopicAliases = null;
        }
    }

    public String toString() {
        return "MQTTSessionState[session=" + this.session + ", clientId=" + this.clientId + ", subscriptions=" + this.subscriptions + ", messageRefStore=" + this.messageRefStore + ", addressMessageMap=" + this.addressMessageMap + ", pubRec=" + this.pubRec + ", attached=" + this.attached + ", outboundStore=" + this.outboundStore + ", disconnectedTime=" + this.disconnectedTime + ", sessionExpiryInterval=" + this.clientSessionExpiryInterval + ", isWill=" + this.isWill + ", willMessage=" + this.willMessage + ", willTopic=" + this.willTopic + ", willQoSLevel=" + this.willQoSLevel + ", willRetain=" + this.willRetain + ", willDelayInterval=" + this.willDelayInterval + ", failed=" + this.failed + ", maxPacketSize=" + this.clientMaxPacketSize + "]@" + System.identityHashCode(this);
    }

    public class OutboundStore {
        private HashMap<Pair<Long, Long>, Integer> artemisToMqttMessageMap = new HashMap();
        private HashMap<Integer, Pair<Long, Long>> mqttToServerIds = new HashMap();
        private final Object dataStoreLock = new Object();
        private int currentId = 0;

        private Pair<Long, Long> generateKey(long messageId, long consumerID) {
            return new Pair((Object)messageId, (Object)consumerID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int generateMqttId(long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Integer id = this.artemisToMqttMessageMap.get(this.generateKey(messageId, consumerId));
                if (id == null) {
                    do {
                        if (this.currentId == MQTTUtil.TWO_BYTE_INT_MAX) {
                            this.currentId = 0;
                        }
                        ++this.currentId;
                    } while (this.mqttToServerIds.containsKey(this.currentId));
                    id = this.currentId;
                }
                return id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(int mqtt, long messageId, long consumerId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> key = this.generateKey(messageId, consumerId);
                this.artemisToMqttMessageMap.put(key, mqtt);
                this.mqttToServerIds.put(mqtt, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Pair<Long, Long> publishAckd(int mqtt) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                Pair<Long, Long> p = this.mqttToServerIds.remove(mqtt);
                if (p != null) {
                    this.artemisToMqttMessageMap.remove(p);
                }
                return p;
            }
        }

        public Pair<Long, Long> publishReceived(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishReleasedSent(int mqttId, long serverMessageId) {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.mqttToServerIds.put(mqttId, (Pair<Long, Long>)new Pair((Object)serverMessageId, (Object)0L));
            }
        }

        public Pair<Long, Long> publishComplete(int mqtt) {
            return this.publishAckd(mqtt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getPendingMessages() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                return this.mqttToServerIds.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.dataStoreLock;
            synchronized (object) {
                this.artemisToMqttMessageMap.clear();
                this.mqttToServerIds.clear();
                this.currentId = 0;
            }
        }
    }

    public static enum WillStatus {
        NOT_SENT,
        SENT,
        SENDING;


        public byte getStatus() {
            switch (this) {
                case NOT_SENT: {
                    return 0;
                }
                case SENT: {
                    return 1;
                }
                case SENDING: {
                    return 2;
                }
            }
            return -1;
        }

        public static WillStatus getStatus(byte status) {
            switch (status) {
                case 0: {
                    return NOT_SENT;
                }
                case 1: {
                    return SENT;
                }
                case 2: {
                    return SENDING;
                }
            }
            return null;
        }
    }
}

