/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.cli.process.ProcessBuilder;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="stop", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ArtemisStopPlugin
extends ArtemisAbstractPlugin {
    private static final String STOP = "stop";
    private PluginDescriptor descriptor;
    @Parameter(defaultValue="${noServer}")
    boolean ignore;
    @Parameter(defaultValue="server")
    String name;
    @Parameter(defaultValue="${activemq.basedir}", required=true)
    private File home;
    @Parameter(defaultValue="${activemq.basedir}/artemis-distribution/target/apache-artemis-${project.version}-bin/apache-artemis-${project.version}/", required=true)
    private File alternateHome;
    @Parameter(defaultValue="${basedir}/target/server0", required=true)
    private File location;
    @Parameter(defaultValue="30000")
    private long spawnTimeout;
    @Parameter
    boolean useSystemOutput = this.getLog().isDebugEnabled();

    @Override
    protected boolean isIgnore() {
        return this.ignore;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        this.home = this.findArtemisHome(this.home, this.alternateHome);
        try {
            final Process process = ProcessBuilder.build((String)this.name, (File)this.location, (boolean)true, (String[])new String[]{STOP});
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    process.destroy();
                }
            });
            boolean complete = process.waitFor(this.spawnTimeout, TimeUnit.MILLISECONDS);
            if (!complete) {
                this.getLog().error((CharSequence)("Stop process did not exit within the spawnTimeout of " + this.spawnTimeout));
                throw new MojoExecutionException("Stop process did not exit within the spawnTimeout of " + this.spawnTimeout);
            }
            Thread.sleep(600L);
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            ProcessBuilder.cleanupProcess();
        }
    }
}

