/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.lockmanager.zookeeper;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import org.apache.activemq.artemis.lockmanager.zookeeper.CuratorDistributedLock;
import org.apache.activemq.artemis.lockmanager.zookeeper.CuratorDistributedPrimitive;
import org.apache.activemq.artemis.lockmanager.zookeeper.CuratorMutableLong;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicLong;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;

public class CuratorDistributedLockManager
implements DistributedLockManager,
ConnectionStateListener {
    private static final String CONNECT_STRING_PARAM = "connect-string";
    private static final String NAMESPACE_PARAM = "namespace";
    private static final String SESSION_MS_PARAM = "session-ms";
    private static final String SESSION_PERCENT_PARAM = "session-percent";
    private static final String CONNECTION_MS_PARAM = "connection-ms";
    private static final String RETRIES_PARAM = "retries";
    private static final String RETRIES_MS_PARAM = "retries-ms";
    private static final Set<String> VALID_PARAMS = Stream.of("connect-string", "namespace", "session-ms", "session-percent", "connection-ms", "retries", "retries-ms").collect(Collectors.toSet());
    private static final String VALID_PARAMS_ON_ERROR = VALID_PARAMS.stream().collect(Collectors.joining(","));
    private static final String DEFAULT_SESSION_TIMEOUT_MS = Integer.toString(18000);
    private static final String DEFAULT_CONNECTION_TIMEOUT_MS = Integer.toString(8000);
    private static final String DEFAULT_RETRIES = Integer.toString(1);
    private static final String DEFAULT_RETRIES_MS = Integer.toString(1000);
    private static final String DEFAULT_SESSION_PERCENT = Integer.toString(33);
    private CuratorFramework client;
    private final Map<PrimitiveId, CuratorDistributedPrimitive> primitives;
    private CopyOnWriteArrayList<DistributedLockManager.UnavailableManagerListener> listeners;
    private boolean unavailable;
    private boolean handlingEvents;
    private final CuratorFrameworkFactory.Builder curatorBuilder;

    private static Map<String, String> validateParameters(Map<String, String> config) {
        config.forEach((parameterName, ignore) -> CuratorDistributedLockManager.validateParameter(parameterName));
        return config;
    }

    private static void validateParameter(String parameterName) {
        if (!VALID_PARAMS.contains(parameterName)) {
            throw new IllegalArgumentException("non existent parameter " + parameterName + ": accepted list is " + VALID_PARAMS_ON_ERROR);
        }
    }

    public CuratorDistributedLockManager(Map<String, String> config) {
        this(CuratorDistributedLockManager.validateParameters(config), true);
    }

    private CuratorDistributedLockManager(Map<String, String> config, boolean ignore) {
        this(config.get(CONNECT_STRING_PARAM), config.get(NAMESPACE_PARAM), Integer.parseInt(config.getOrDefault(SESSION_MS_PARAM, DEFAULT_SESSION_TIMEOUT_MS)), Integer.parseInt(config.getOrDefault(SESSION_PERCENT_PARAM, DEFAULT_SESSION_PERCENT)), Integer.parseInt(config.getOrDefault(CONNECTION_MS_PARAM, DEFAULT_CONNECTION_TIMEOUT_MS)), Integer.parseInt(config.getOrDefault(RETRIES_PARAM, DEFAULT_RETRIES)), Integer.parseInt(config.getOrDefault(RETRIES_MS_PARAM, DEFAULT_RETRIES_MS)));
    }

    private CuratorDistributedLockManager(String connectString, String namespace, int sessionMs, int sessionPercent, int connectionMs, int retries, int retriesMs) {
        this.curatorBuilder = CuratorFrameworkFactory.builder().connectString(connectString).namespace(namespace).sessionTimeoutMs(sessionMs).connectionTimeoutMs(connectionMs).retryPolicy((RetryPolicy)(retries >= 0 ? new RetryNTimes(retries, retriesMs) : new RetryForever(retriesMs))).simulatedSessionExpirationPercent(sessionPercent);
        this.primitives = new HashMap<PrimitiveId, CuratorDistributedPrimitive>();
        this.listeners = null;
        this.unavailable = false;
        this.handlingEvents = false;
    }

    public synchronized boolean isStarted() {
        this.checkHandlingEvents();
        return this.client != null;
    }

    public synchronized void addUnavailableManagerListener(DistributedLockManager.UnavailableManagerListener listener) {
        this.checkHandlingEvents();
        if (this.listeners == null) {
            return;
        }
        this.listeners.add(listener);
        if (this.unavailable) {
            this.startHandlingEvents();
            try {
                listener.onUnavailableManagerEvent();
            }
            finally {
                this.completeHandlingEvents();
            }
        }
    }

    public synchronized void removeUnavailableManagerListener(DistributedLockManager.UnavailableManagerListener listener) {
        this.checkHandlingEvents();
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public synchronized boolean start(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        this.checkHandlingEvents();
        if (timeout >= 0L) {
            if (timeout > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("curator manager won't support too long timeout ie >2147483647");
            }
            Objects.requireNonNull(unit);
        }
        if (this.client != null) {
            return true;
        }
        CuratorFramework client = this.curatorBuilder.build();
        try {
            client.start();
            if (!client.blockUntilConnected((int)timeout, unit)) {
                client.close();
                return false;
            }
            this.client = client;
            this.listeners = new CopyOnWriteArrayList();
            client.getConnectionStateListenable().addListener((Object)this);
            return true;
        }
        catch (InterruptedException e) {
            client.close();
            throw e;
        }
    }

    public synchronized void start() throws InterruptedException, ExecutionException {
        this.start(-1L, null);
    }

    public synchronized void stop() {
        this.checkHandlingEvents();
        CuratorFramework client = this.client;
        if (client == null) {
            return;
        }
        this.client = null;
        this.unavailable = false;
        this.listeners.clear();
        this.listeners = null;
        client.getConnectionStateListenable().removeListener((Object)this);
        this.primitives.forEach((id, primitive) -> {
            try {
                primitive.onRemoved();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.primitives.clear();
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T extends CuratorDistributedPrimitive> T getPrimitive(PrimitiveId id, Function<PrimitiveId, ? extends T> primitiveFactory) {
        this.checkHandlingEvents();
        Objects.requireNonNull(id);
        if (this.client == null) {
            throw new IllegalStateException("manager isn't started yet!");
        }
        CuratorDistributedPrimitive primitive = PrimitiveType.validatePrimitiveInstance(this.primitives.get(id));
        if (primitive != null) {
            return (T)primitive;
        }
        CuratorDistributedPrimitive newPrimitive = PrimitiveType.validatePrimitiveInstance((CuratorDistributedPrimitive)primitiveFactory.apply(id));
        this.primitives.put(id, newPrimitive);
        if (this.unavailable) {
            this.startHandlingEvents();
            try {
                newPrimitive.onLost();
            }
            finally {
                this.completeHandlingEvents();
            }
        }
        return (T)newPrimitive;
    }

    public DistributedLock getDistributedLock(String lockId) {
        return this.getPrimitive(PrimitiveId.of(lockId, PrimitiveType.lock), id -> new CuratorDistributedLock((PrimitiveId)id, this, new InterProcessSemaphoreV2(this.client, "/" + id.id + "/locks", 1)));
    }

    public MutableLong getMutableLong(String mutableLongId) {
        return this.getPrimitive(PrimitiveId.of(mutableLongId, PrimitiveType.mutableLong), id -> new CuratorMutableLong((PrimitiveId)id, this, new DistributedAtomicLong(this.client, "/" + mutableLongId + "/activation-sequence", (RetryPolicy)new RetryNTimes(0, 0))));
    }

    protected void startHandlingEvents() {
        this.handlingEvents = true;
    }

    protected void completeHandlingEvents() {
        this.handlingEvents = false;
    }

    protected void checkHandlingEvents() {
        if (this.client == null) {
            return;
        }
        if (this.handlingEvents) {
            throw new IllegalStateException("UnavailableManagerListener isn't supposed to modify the manager or its primitives on event handling!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.client != client) {
            return;
        }
        if (this.unavailable) {
            return;
        }
        this.startHandlingEvents();
        try {
            switch (newState) {
                case LOST: {
                    this.unavailable = true;
                    this.listeners.forEach(listener -> listener.onUnavailableManagerEvent());
                    this.primitives.forEach((id, primitive) -> primitive.onLost());
                    return;
                }
                case RECONNECTED: {
                    this.primitives.forEach((id, primitive) -> primitive.onReconnected());
                    return;
                }
                case SUSPENDED: {
                    this.primitives.forEach((id, primitive) -> primitive.onSuspended());
                    return;
                }
            }
            return;
        }
        finally {
            this.completeHandlingEvents();
        }
    }

    public synchronized CuratorFramework getCurator() {
        this.checkHandlingEvents();
        return this.client;
    }

    public synchronized void remove(CuratorDistributedPrimitive primitive) {
        this.checkHandlingEvents();
        this.primitives.remove(primitive.getId());
    }

    static {
        if (System.getProperty("curator-log-events") == null) {
            System.setProperty("curator-log-events", "false");
        }
    }

    static enum PrimitiveType {
        lock,
        mutableLong;


        static <T extends CuratorDistributedPrimitive> T validatePrimitiveInstance(T primitive) {
            if (primitive == null) {
                return null;
            }
            boolean valid = false;
            switch (primitive.getId().type) {
                case lock: {
                    valid = primitive instanceof CuratorDistributedLock;
                    break;
                }
                case mutableLong: {
                    valid = primitive instanceof CuratorMutableLong;
                }
            }
            if (!valid) {
                throw new AssertionError((Object)("Implementation error: " + primitive.getClass() + " is wrongly considered " + primitive.getId().type));
            }
            return primitive;
        }
    }

    static final class PrimitiveId {
        final String id;
        final PrimitiveType type;

        private PrimitiveId(String id, PrimitiveType type) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
        }

        static PrimitiveId of(String id, PrimitiveType type) {
            return new PrimitiveId(id, type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimitiveId that = (PrimitiveId)o;
            if (!Objects.equals(this.id, that.id)) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

