/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveMQClientDelegate {
    Logger log = LoggerFactory.getLogger(this.getClass());
    boolean autoCreateQueue = true;
    ServerLocator serverLocator;
    ClientSessionFactory sessionFactory;
    ClientSession session;
    String username;
    String password;

    public AbstractActiveMQClientDelegate(String url, String username, String password) {
        this(url);
        this.username = username;
        this.password = password;
    }

    public AbstractActiveMQClientDelegate(String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Error creating %s - url cannot be null", this.getClass().getSimpleName()));
        }
        try {
            this.serverLocator = ActiveMQClient.createServerLocator((String)url);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error creating %s - createServerLocator( %s ) failed", this.getClass().getSimpleName(), url), ex);
        }
    }

    public AbstractActiveMQClientDelegate(ServerLocator serverLocator, String username, String password) {
        this(serverLocator);
        this.username = username;
        this.password = password;
    }

    public AbstractActiveMQClientDelegate(ServerLocator serverLocator) {
        if (serverLocator == null) {
            throw new IllegalArgumentException(String.format("Error creating %s - ServerLocator cannot be null", this.getClass().getSimpleName()));
        }
        this.serverLocator = serverLocator;
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        if (properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                message.putObjectProperty(property.getKey(), property.getValue());
            }
        }
    }

    void start() {
        this.log.info("Starting {}", (Object)this.getClass().getSimpleName());
        try {
            this.sessionFactory = this.serverLocator.createSessionFactory();
            this.session = this.sessionFactory.createSession(this.username, this.password, false, true, true, this.serverLocator.isPreAcknowledge(), this.serverLocator.getAckBatchSize());
        }
        catch (RuntimeException runtimeEx) {
            throw runtimeEx;
        }
        catch (Exception ex) {
            throw new ActiveMQClientResourceException(String.format("%s initialisation failure", this.getClass().getSimpleName()), ex);
        }
        this.createClient();
        try {
            this.session.start();
        }
        catch (ActiveMQException amqEx) {
            throw new ActiveMQClientResourceException(String.format("%s startup failure", this.getClass().getSimpleName()), (Exception)((Object)amqEx));
        }
    }

    void stop() {
        this.stopClient();
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (ActiveMQException amqEx) {
                this.log.warn("ActiveMQException encountered closing InternalClient ClientSession - ignoring", (Throwable)amqEx);
            }
            finally {
                this.session = null;
            }
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.serverLocator != null) {
            this.serverLocator.close();
            this.serverLocator = null;
        }
    }

    protected abstract void createClient();

    protected abstract void stopClient();

    public boolean isAutoCreateQueue() {
        return this.autoCreateQueue;
    }

    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.autoCreateQueue = autoCreateQueue;
    }

    public static class ActiveMQClientResourceException
    extends RuntimeException {
        public ActiveMQClientResourceException(String message) {
            super(message);
        }

        public ActiveMQClientResourceException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

