/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.LocalAddress;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.PropertyConverters;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.PING;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataInputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.StackType;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ThreadFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MPING
extends PING
implements Runnable {
    @LocalAddress
    @Property(description="Bind address for multicast socket. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"})
    protected InetAddress bind_addr;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str;
    @Property(description="Time to live for discovery packets. Default is 8", systemProperty={"jgroups.mping.ip_ttl"})
    protected int ip_ttl = 8;
    @Property(description="Multicast address to be used for discovery", name="mcast_addr", systemProperty={"jgroups.mping.mcast_addr"}, defaultValueIPv4="232.5.6.7", defaultValueIPv6="ff0e::5:6:7")
    protected InetAddress mcast_addr;
    @Property(description="Multicast port for discovery packets. Default is 7555", systemProperty={"jgroups.mping.mcast_port"})
    protected int mcast_port = 7555;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages")
    protected boolean receive_on_all_interfaces;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces;
    @Property(description="Whether send messages are sent on all interfaces. Default is false")
    protected boolean send_on_all_interfaces;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="List of interfaces to send multicasts on")
    protected List<NetworkInterface> send_interfaces;
    protected MulticastSocket mcast_receive_sock;
    protected MulticastSocket mcast_send_sock;
    protected MulticastSocket[] mcast_send_sockets;
    protected volatile Thread receiver;

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public MPING setBindAddr(InetAddress b) {
        this.bind_addr = b;
        return this;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public List<NetworkInterface> getSendInterfaces() {
        return this.send_interfaces;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public int getTTL() {
        return this.ip_ttl;
    }

    public MPING setTTL(int ip_ttl) {
        this.ip_ttl = ip_ttl;
        return this;
    }

    public InetAddress getMcastAddr() {
        return this.mcast_addr;
    }

    public MPING mcastAddress(InetAddress a) {
        this.mcast_addr = a;
        return this;
    }

    public MPING setMcastAddr(InetAddress a) {
        this.mcast_addr = a;
        return this;
    }

    public int getMcastPort() {
        return this.mcast_port;
    }

    public MPING setMcastPort(int p) {
        this.mcast_port = p;
        return this;
    }

    public MPING setMulticastAddress(String a) throws UnknownHostException {
        this.mcast_addr = InetAddress.getByName(a);
        return this;
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 56) {
            if (this.bind_addr == null) {
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
            return this.up_prot.up(evt);
        }
        return super.up(evt);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.log.debug("bind_addr=%s, mcast_addr=%s, mcast_port=%d", this.bind_addr, this.mcast_addr, this.mcast_port);
    }

    @Override
    public void start() throws Exception {
        if (this.bind_addr == null) {
            this.bind_addr = this.getTransport().getBindAddr();
        }
        this.mcast_receive_sock = Util.can_bind_to_mcast_addr ? Util.createMulticastSocket(this.getSocketFactory(), "jgroups.mping.mcast_sock", this.mcast_addr, this.mcast_port, this.log) : this.getSocketFactory().createMulticastSocket("jgroups.mping.mcast_sock", this.mcast_port);
        this.mcast_receive_sock.setTimeToLive(this.ip_ttl);
        if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
            List<NetworkInterface> interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.mcast_receive_sock, this.mcast_addr);
        } else {
            if (this.bind_addr != null) {
                this.mcast_receive_sock.setNetworkInterface(NetworkInterface.getByInetAddress(this.bind_addr));
            }
            InetSocketAddress group = new InetSocketAddress(this.mcast_addr, this.mcast_port);
            NetworkInterface intf = this.bind_addr == null ? null : NetworkInterface.getByInetAddress(this.bind_addr);
            this.log.debug("%s: joining group %s on NIC %s\n", this.local_addr, group, intf);
            this.mcast_receive_sock.joinGroup(group, intf);
        }
        if (this.send_on_all_interfaces || this.send_interfaces != null && !this.send_interfaces.isEmpty()) {
            List<NetworkInterface> nics = this.send_interfaces != null ? this.send_interfaces : Util.getAllAvailableInterfaces();
            this.mcast_send_sockets = new MulticastSocket[nics.size()];
            int index = 0;
            for (NetworkInterface intf : nics) {
                this.mcast_send_sockets[index] = new MulticastSocket();
                this.mcast_send_sockets[index].setNetworkInterface(intf);
                this.mcast_send_sockets[index].setTimeToLive(this.ip_ttl);
                ++index;
            }
        } else {
            this.mcast_send_sock = this.createMulticastSocket("jgroups.mping.mcast-send-sock", 0);
        }
        this.startReceiver();
        super.start();
    }

    @Override
    public void stop() {
        this.receiver = null;
        Util.close((Closeable)this.mcast_receive_sock);
        this.mcast_receive_sock = null;
        super.stop();
    }

    @Override
    public void run() {
        byte[] receive_buf = new byte[65535];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receive_sock != null && Thread.currentThread().equals(this.receiver)) {
            packet.setData(receive_buf, 0, receive_buf.length);
            try {
                this.mcast_receive_sock.receive(packet);
                ByteArrayDataInputStream inp = new ByteArrayDataInputStream(packet.getData(), packet.getOffset(), packet.getLength());
                BytesMessage msg = new BytesMessage();
                msg.readFrom(inp);
                if (Objects.equals(this.local_addr, msg.getSrc())) continue;
                this.up(msg);
            }
            catch (SocketException socketEx) {
                break;
            }
            catch (Throwable ex) {
                this.log.error(Util.getMessage("FailedReceivingPacketFrom"), packet.getSocketAddress(), ex);
            }
        }
    }

    protected MulticastSocket createMulticastSocket(String service_name, int port) throws Exception {
        MulticastSocket retval = this.getSocketFactory().createMulticastSocket(service_name, null);
        if (this.bind_addr != null) {
            this.setInterface(this.bind_addr, retval);
        }
        retval.setTimeToLive(this.ip_ttl);
        retval.setReuseAddress(false);
        retval.bind(new InetSocketAddress(this.bind_addr, port));
        return retval;
    }

    protected <T extends MPING> T setInterface(InetAddress intf, MulticastSocket s) {
        try {
            if (s != null && intf != null) {
                s.setNetworkInterface(NetworkInterface.getByInetAddress(intf));
            }
        }
        catch (Throwable ex) {
            this.log.error("failed setting interface to %s: %s", intf, ex);
        }
        return (T)this;
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcast_addr) throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcast_addr, this.mcast_port);
        block0: for (NetworkInterface i : interfaces) {
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if ((Util.getIpStackType() != StackType.IPv4 || !(addr instanceof Inet4Address)) && (Util.getIpStackType() != StackType.IPv6 || !(addr instanceof Inet6Address))) continue;
                s.joinGroup(tmp_mcast_addr, i);
                this.log.trace("joined " + tmp_mcast_addr + " on " + i.getName() + " (" + addr + ")");
                continue block0;
            }
        }
    }

    protected void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            ThreadFactory factory = this.getThreadFactory();
            this.receiver = factory != null ? factory.newThread(this, "MPING") : new Thread((Runnable)this, "MPING)");
            this.receiver.setDaemon(true);
            this.receiver.start();
            this.log.debug("receiver thread started");
        }
    }

    @Override
    protected void sendMcastDiscoveryRequest(Message msg) {
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(msg.size() + 1);
            msg.writeTo(out);
            ByteArray buf = out.getBuffer();
            DatagramPacket packet = new DatagramPacket(buf.getArray(), buf.getOffset(), buf.getLength(), this.mcast_addr, this.mcast_port);
            if (this.mcast_send_sockets != null) {
                for (int i = 0; i < this.mcast_send_sockets.length; ++i) {
                    MulticastSocket s = this.mcast_send_sockets[i];
                    try {
                        s.send(packet);
                        continue;
                    }
                    catch (Exception e) {
                        this.log.error(Util.getMessage("FailedSendingPacketOnSocket"), s);
                    }
                }
            } else if (this.mcast_send_sock != null) {
                this.mcast_send_sock.send(packet);
            }
        }
        catch (Exception ex) {
            this.log.error(String.format("%s: failed sending discovery request to %s", this.local_addr, this.mcast_addr + ":" + this.mcast_port), ex);
        }
    }
}

