/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.config;

import org.apache.activemq.artemis.api.core.client.ActiveMQClient;

public class ServerLocatorConfig {
    public long clientFailureCheckPeriod = ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    public long connectionTTL = ActiveMQClient.DEFAULT_CONNECTION_TTL;
    public long callTimeout = 30000L;
    public long callFailoverTimeout = 30000L;
    public int minLargeMessageSize = 102400;
    public int consumerWindowSize = 0x100000;
    public int consumerMaxRate = -1;
    public int confirmationWindowSize = -1;
    public int producerWindowSize = 65536;
    public int producerMaxRate = -1;
    public boolean blockOnAcknowledge = false;
    public boolean blockOnDurableSend = true;
    public boolean blockOnNonDurableSend = false;
    public boolean autoGroup = false;
    public boolean preAcknowledge = false;
    public int ackBatchSize = 0x100000;
    public String connectionLoadBalancingPolicyClassName = ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    public boolean useGlobalPools = true;
    public int threadPoolMaxSize = -1;
    public int scheduledThreadPoolMaxSize = 5;
    public int flowControlThreadPoolMaxSize = 10;
    public long retryInterval = 2000L;
    public double retryIntervalMultiplier = ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    public long maxRetryInterval = ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL;
    public int reconnectAttempts = 0;
    public int initialConnectAttempts = 1;
    public int failoverAttempts = 0;
    public int initialMessagePacketSize = 1500;
    public int onMessageCloseTimeout = 10000;
    public boolean cacheLargeMessagesClient = false;
    public int compressionLevel = -1;
    public boolean compressLargeMessage = false;
    public boolean useTopologyForLoadBalancing = true;

    public ServerLocatorConfig() {
    }

    public ServerLocatorConfig(ServerLocatorConfig locator) {
        this.compressLargeMessage = locator.compressLargeMessage;
        this.cacheLargeMessagesClient = locator.cacheLargeMessagesClient;
        this.clientFailureCheckPeriod = locator.clientFailureCheckPeriod;
        this.connectionTTL = locator.connectionTTL;
        this.callTimeout = locator.callTimeout;
        this.callFailoverTimeout = locator.callFailoverTimeout;
        this.minLargeMessageSize = locator.minLargeMessageSize;
        this.consumerWindowSize = locator.consumerWindowSize;
        this.consumerMaxRate = locator.consumerMaxRate;
        this.confirmationWindowSize = locator.confirmationWindowSize;
        this.producerWindowSize = locator.producerWindowSize;
        this.producerMaxRate = locator.producerMaxRate;
        this.blockOnAcknowledge = locator.blockOnAcknowledge;
        this.blockOnDurableSend = locator.blockOnDurableSend;
        this.blockOnNonDurableSend = locator.blockOnNonDurableSend;
        this.autoGroup = locator.autoGroup;
        this.preAcknowledge = locator.preAcknowledge;
        this.connectionLoadBalancingPolicyClassName = locator.connectionLoadBalancingPolicyClassName;
        this.ackBatchSize = locator.ackBatchSize;
        this.useGlobalPools = locator.useGlobalPools;
        this.scheduledThreadPoolMaxSize = locator.scheduledThreadPoolMaxSize;
        this.flowControlThreadPoolMaxSize = locator.flowControlThreadPoolMaxSize;
        this.threadPoolMaxSize = locator.threadPoolMaxSize;
        this.retryInterval = locator.retryInterval;
        this.retryIntervalMultiplier = locator.retryIntervalMultiplier;
        this.maxRetryInterval = locator.maxRetryInterval;
        this.reconnectAttempts = locator.reconnectAttempts;
        this.initialConnectAttempts = locator.initialConnectAttempts;
        this.failoverAttempts = locator.failoverAttempts;
        this.initialMessagePacketSize = locator.initialMessagePacketSize;
        this.useTopologyForLoadBalancing = locator.useTopologyForLoadBalancing;
        this.compressionLevel = locator.compressionLevel;
    }
}

