/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.SSL_KEY_EXCHANGE;

public class CertficateCNMatcher
implements SSL_KEY_EXCHANGE.SessionVerifier {
    protected String cn_name;
    protected Pattern pattern;

    @Override
    public void init(String arg) {
        this.cn_name = arg;
        this.pattern = Pattern.compile(this.cn_name);
    }

    @Override
    public void verify(SSLSession session) throws SecurityException {
        Principal principal = null;
        try {
            principal = session.getPeerPrincipal();
            String name = principal.getName();
            Matcher m = this.pattern.matcher(name);
            boolean find = m.find();
            if (!find) {
                throw new SecurityException(String.format("pattern '%s' not found in peer certificate '%s'", this.cn_name, name));
            }
            System.out.printf("** pattern '%s' found in peer certificate '%s'\n", this.cn_name, name);
        }
        catch (SSLPeerUnverifiedException e) {
            throw new SecurityException(e);
        }
    }
}

