/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageProducer;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueBrowser;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQBytesCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQMapCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQObjectCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQStreamCompatibleMessage;
import org.apache.activemq.artemis.jms.client.compatible1X.ActiveMQTextCompatibleMessage;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.AutoCreateUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.SelectorTranslator;

public class ActiveMQSession
implements QueueSession,
TopicSession {
    public static final int TYPE_GENERIC_SESSION = 0;
    public static final int TYPE_QUEUE_SESSION = 1;
    public static final int TYPE_TOPIC_SESSION = 2;
    private static SimpleString REJECTING_FILTER = SimpleString.of("_AMQX=-1");
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final ClientSession session;
    private final int sessionType;
    private final int ackMode;
    private final boolean transacted;
    private final boolean xa;
    private boolean recoverCalled;
    private final Set<ActiveMQMessageConsumer> consumers = new HashSet<ActiveMQMessageConsumer>();
    private final boolean cacheDestination;
    private final boolean enable1xPrefixes;
    private final Map<String, Topic> topicCache = new ConcurrentHashMap<String, Topic>();
    private final Map<String, Queue> queueCache = new ConcurrentHashMap<String, Queue>();

    protected ActiveMQSession(ConnectionFactoryOptions options, ActiveMQConnection connection, boolean transacted, boolean xa, int ackMode, boolean cacheDestination, boolean enable1xPrefixes, ClientSession session, int sessionType) {
        this.options = options;
        this.connection = connection;
        this.ackMode = ackMode;
        this.session = session;
        this.sessionType = sessionType;
        this.transacted = transacted;
        this.xa = xa;
        this.cacheDestination = cacheDestination;
        this.enable1xPrefixes = enable1xPrefixes;
    }

    @Override
    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        ActiveMQBytesMessage message = this.enable1xPrefixes ? new ActiveMQBytesCompatibleMessage(this.session) : new ActiveMQBytesMessage(this.session);
        return message;
    }

    @Override
    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        ActiveMQMapMessage message = this.enable1xPrefixes ? new ActiveMQMapCompatibleMessage(this.session) : new ActiveMQMapMessage(this.session);
        return message;
    }

    @Override
    public Message createMessage() throws JMSException {
        this.checkClosed();
        ActiveMQMessage message = this.enable1xPrefixes ? new ActiveMQCompatibleMessage(this.session) : new ActiveMQMessage(this.session);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage message = this.enable1xPrefixes ? new ActiveMQObjectCompatibleMessage(this.session, this.options) : new ActiveMQObjectMessage(this.session, this.options);
        return message;
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage msg = this.enable1xPrefixes ? new ActiveMQObjectCompatibleMessage(this.session, this.options) : new ActiveMQObjectMessage(this.session, this.options);
        msg.setObject(object);
        return msg;
    }

    @Override
    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        ActiveMQStreamMessage message = this.enable1xPrefixes ? new ActiveMQStreamCompatibleMessage(this.session) : new ActiveMQStreamMessage(this.session);
        return message;
    }

    @Override
    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = this.enable1xPrefixes ? new ActiveMQTextCompatibleMessage(this.session) : new ActiveMQTextMessage(this.session);
        msg.setText(null);
        return msg;
    }

    @Override
    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = this.enable1xPrefixes ? new ActiveMQTextCompatibleMessage(this.session) : new ActiveMQTextMessage(this.session);
        msg.setText(text);
        return msg;
    }

    @Override
    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    @Override
    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.ackMode;
    }

    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot commit a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call commit on an XA session");
        }
        try {
            this.session.commit();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot rollback a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call rollback on an XA session");
        }
        try {
            this.session.rollback();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        this.connection.getThreadAwareContext().assertNotMessageListenerThread();
        ActiveMQConnection activeMQConnection = this.connection;
        synchronized (activeMQConnection) {
            try {
                for (ActiveMQMessageConsumer cons : new HashSet<ActiveMQMessageConsumer>(this.consumers)) {
                    cons.close();
                }
                this.session.close();
                this.connection.removeSession(this);
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
        this.topicCache.clear();
        this.queueCache.clear();
    }

    @Override
    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Cannot recover a transacted session");
        }
        try {
            this.session.rollback(true);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        this.recoverCalled = true;
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
    }

    @Override
    public void run() {
    }

    @Override
    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQ Artemis Destination:" + String.valueOf(destination));
        }
        try {
            ActiveMQDestination jbd = (ActiveMQDestination)destination;
            if (jbd != null) {
                this.checkDestination(jbd);
            }
            ClientProducer producer = this.session.createProducer(jbd == null ? null : jbd.getSimpleAddress());
            return new ActiveMQMessageProducer(this.connection, producer, jbd, this, this.options);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void checkDestination(ActiveMQDestination destination) throws JMSException {
        SimpleString address = destination.getSimpleAddress();
        if (destination.isCreated()) return;
        try {
            ClientSession.QueueQuery queueQuery;
            ClientSession.AddressQuery addressQuery = this.session.addressQuery(address);
            if (!addressQuery.isExists()) {
                if (destination.isQueue()) {
                    if (!addressQuery.isAutoCreateAddresses() || !addressQuery.isAutoCreateQueues()) throw new InvalidDestinationException("Destination " + String.valueOf(address) + " does not exist, autoCreateAddresses=" + addressQuery.isAutoCreateAddresses() + " , autoCreateQueues=" + addressQuery.isAutoCreateQueues());
                    this.session.createAddress(address, RoutingType.ANYCAST, true);
                } else {
                    if (!addressQuery.isAutoCreateAddresses()) throw new InvalidDestinationException("Destination " + String.valueOf(address) + " does not exist, autoCreateAddresses=" + addressQuery.isAutoCreateAddresses());
                    this.session.createAddress(address, RoutingType.MULTICAST, true);
                }
            } else if (!addressQuery.isSupportsMulticast() && !destination.isQueue() || !addressQuery.isSupportsAnycast() && destination.isQueue()) {
                throw new InvalidDestinationException("Destination " + String.valueOf(address) + " exists, but does not support " + (destination.isQueue() ? RoutingType.ANYCAST.name() : RoutingType.MULTICAST.name()) + " routing");
            }
            if (destination.isQueue()) {
                ClientSession.QueueQuery queueQuery2 = this.session.queueQuery(address);
                if (!queueQuery2.isExists()) {
                    if (!addressQuery.isAutoCreateQueues()) throw new InvalidDestinationException("Destination " + String.valueOf(address) + " does not exist, address exists but autoCreateQueues=" + addressQuery.isAutoCreateQueues());
                    if (destination.isTemporary()) {
                        this.createTemporaryQueue(destination, RoutingType.ANYCAST, address, null, addressQuery);
                    } else {
                        this.createQueue(destination, RoutingType.ANYCAST, address, null, true, true, addressQuery);
                    }
                }
            } else if (CompositeAddress.isFullyQualified(address) && !(queueQuery = this.session.queueQuery(address)).isExists()) {
                if (!addressQuery.isAutoCreateQueues()) throw new InvalidDestinationException("Destination " + String.valueOf(address) + " does not exist, address exists but autoCreateQueues=" + addressQuery.isAutoCreateQueues());
                if (destination.isTemporary()) {
                    this.createTemporaryQueue(destination, RoutingType.MULTICAST, address, null, addressQuery);
                } else {
                    this.createQueue(destination, RoutingType.MULTICAST, address, null, true, true, addressQuery);
                }
            }
        }
        catch (ActiveMQQueueExistsException addressQuery) {
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        destination.setCreated(true);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    @Override
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQDestination:" + String.valueOf(destination));
        }
        ActiveMQDestination jbdest = (ActiveMQDestination)destination;
        if (jbdest.isTemporary() && !this.connection.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + String.valueOf(destination) + " from another JMS connection");
        }
        return this.createConsumer(jbdest, null, messageSelector, noLocal, ConsumerDurability.NON_DURABLE);
    }

    @Override
    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        try {
            Queue queue = null;
            if (this.cacheDestination) {
                queue = this.queueCache.get(queueName);
            }
            if (queue == null) {
                queue = this.internalCreateQueue(queueName);
            }
            if (this.cacheDestination) {
                this.queueCache.put(queueName, queue);
            }
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    protected Queue internalCreateQueue(String queueName) throws ActiveMQException, JMSException {
        ActiveMQQueue queue = this.lookupQueue(queueName, false);
        if (queue == null) {
            queue = this.lookupQueue(queueName, true);
        }
        if (queue == null) {
            queue = this.internalCreateQueueCompatibility("jms.queue." + queueName);
        }
        if (queue == null) {
            throw new JMSException("There is no queue with name " + queueName);
        }
        return queue;
    }

    protected ActiveMQQueue internalCreateQueueCompatibility(String queueName) throws ActiveMQException, JMSException {
        ActiveMQQueue queue = this.lookupQueue(queueName, false);
        if (queue == null) {
            queue = this.lookupQueue(queueName, true);
        }
        return queue;
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        try {
            Topic topic = null;
            if (this.cacheDestination) {
                topic = this.topicCache.get(topicName);
            }
            if (topic == null) {
                topic = this.internalCreateTopic(topicName, false);
            }
            if (this.cacheDestination) {
                this.topicCache.put(topicName, topic);
            }
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    protected Topic internalCreateTopic(String topicName, boolean retry) throws ActiveMQException, JMSException {
        ActiveMQTopic topic = this.lookupTopic(topicName, false);
        if (topic == null) {
            topic = this.lookupTopic(topicName, true);
        }
        if (topic == null) {
            if (!retry) {
                return this.internalCreateTopic("jms.topic." + topicName, true);
            }
            throw new JMSException("There is no topic with name " + topicName);
        }
        return topic;
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        this.checkTopic(topic);
        if (!(topic instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQTopic:" + String.valueOf(topic));
        }
        ActiveMQDestination jbdest = (ActiveMQDestination)((Object)topic);
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        if (jbdest.isQueue()) {
            throw new InvalidDestinationException("Cannot create a subscriber on a queue");
        }
        return this.createConsumer(jbdest, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    private void checkTopic(Topic topic) throws InvalidDestinationException {
        if (topic == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    @Override
    public MessageConsumer createSharedConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        ActiveMQTopic activeMQTopic;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (activeMQTopic = (ActiveMQTopic)topic) : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.NON_DURABLE);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableConsumer(topic, name, null, false);
    }

    @Override
    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        ActiveMQTopic activeMQTopic;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (activeMQTopic = (ActiveMQTopic)topic) : new ActiveMQTopic(topic.getTopicName());
        return this.createConsumer(localTopic, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    @Override
    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        ActiveMQTopic activeMQTopic;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (activeMQTopic = (ActiveMQTopic)topic) : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.DURABLE);
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationBlackList() {
        return this.getDeserializationDenyList();
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationWhiteList() {
        return this.getDeserializationAllowList();
    }

    public String getDeserializationDenyList() {
        return this.connection.getDeserializationDenyList();
    }

    public String getDeserializationAllowList() {
        return this.connection.getDeserializationAllowList();
    }

    private ActiveMQMessageConsumer internalCreateSharedConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, ConsumerDurability durability) throws JMSException {
        try {
            if (dest.isQueue()) {
                throw new RuntimeException("Internal error: createSharedConsumer is only meant for Topics");
            }
            if (subscriptionName == null) {
                throw ActiveMQJMSClientBundle.BUNDLE.invalidSubscriptionName();
            }
            selectorString = "".equals(selectorString) ? null : selectorString;
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = SimpleString.of(SelectorTranslator.convertToActiveMQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            ClientSession.AddressQuery response = this.session.addressQuery(dest.getSimpleAddress());
            if (!response.isExists() && !response.isAutoCreateAddresses()) {
                throw ActiveMQJMSClientBundle.BUNDLE.destinationDoesNotExist(dest.getSimpleAddress());
            }
            if (dest.isTemporary() && durability == ConsumerDurability.DURABLE) {
                throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
            }
            SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(durability == ConsumerDurability.DURABLE, this.connection.getClientID(), subscriptionName);
            ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
            if (!(subResponse.isExists() && Objects.equals(subResponse.getAddress(), dest.getSimpleAddress()) && Objects.equals(subResponse.getFilterString(), coreFilterString) || Boolean.TRUE.equals(subResponse.isConfigurationManaged()))) {
                try {
                    this.createSharedQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, durability == ConsumerDurability.DURABLE, response);
                }
                catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                    // empty catch block
                }
            }
            ClientConsumer consumer = this.createClientConsumer(dest, queueName, null);
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.options, this.connection, this, consumer, false, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    private ActiveMQMessageConsumer createConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, boolean noLocal, ConsumerDurability durability) throws JMSException {
        try {
            ClientConsumer consumer;
            Object object = selectorString = "".equals(selectorString) ? null : selectorString;
            if (noLocal) {
                this.connection.setHasNoLocal();
                String filter = this.connection.getClientID() != null ? ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getClientID() + "'" : ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + String.valueOf(this.connection.getUID()) + "'";
                selectorString = selectorString != null ? (String)selectorString + " AND " + filter : filter;
            }
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = SimpleString.of(SelectorTranslator.convertToActiveMQFilterString((String)selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            if (dest.isQueue()) {
                try {
                    AutoCreateUtil.autoCreateQueue(this.session, dest.getSimpleAddress(), null);
                }
                catch (ActiveMQException ex) {
                    if (ex.getType() == ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST) {
                        throw new InvalidDestinationException("Destination " + dest.getName() + " does not exist");
                    }
                    throw ex;
                }
                dest.setCreated(true);
                consumer = this.createClientConsumer(dest, null, coreFilterString);
            } else {
                ClientSession.AddressQuery response = this.session.addressQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    if (response.isAutoCreateAddresses()) {
                        this.session.createAddress(dest.getSimpleAddress(), RoutingType.MULTICAST, true);
                    } else {
                        throw new InvalidDestinationException("Topic " + dest.getName() + " does not exist");
                    }
                }
                dest.setCreated(true);
                if (subscriptionName == null) {
                    SimpleString queueName;
                    if (durability != ConsumerDurability.NON_DURABLE) {
                        throw new RuntimeException("Subscription name cannot be null for durable topic consumer");
                    }
                    if (CompositeAddress.isFullyQualified(dest.getAddress())) {
                        queueName = this.createFQQNSubscription(dest, coreFilterString, response);
                    } else {
                        queueName = SimpleString.of(UUID.randomUUID().toString());
                        this.createTemporaryQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, response);
                    }
                    consumer = this.createClientConsumer(dest, queueName, coreFilterString);
                    autoDeleteQueueName = queueName;
                } else {
                    if (durability != ConsumerDurability.DURABLE) {
                        throw new RuntimeException("Subscription name must be null for non-durable topic consumer");
                    }
                    if (this.connection.getClientID() == null) {
                        throw new IllegalStateException("Cannot create durable subscription - client ID has not been set");
                    }
                    if (dest.isTemporary()) {
                        throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                    }
                    SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(true, this.connection.getClientID(), subscriptionName);
                    ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
                    if (!subResponse.isExists()) {
                        this.createQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, true, false, response);
                    } else {
                        boolean topicChanged;
                        if (subResponse.getConsumerCount() > 0) {
                            throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                        }
                        SimpleString oldFilterString = subResponse.getFilterString();
                        boolean selectorChanged = coreFilterString == null && oldFilterString != null || oldFilterString == null && coreFilterString != null || oldFilterString != null && coreFilterString != null && !oldFilterString.equals(coreFilterString);
                        SimpleString oldTopicName = subResponse.getAddress();
                        boolean bl = topicChanged = !oldTopicName.equals(dest.getSimpleAddress());
                        if ((selectorChanged || topicChanged) && !Boolean.TRUE.equals(subResponse.isConfigurationManaged())) {
                            this.session.deleteQueue(queueName);
                            this.createQueue(dest, RoutingType.MULTICAST, queueName, coreFilterString, true, false, response);
                        }
                    }
                    consumer = this.createClientConsumer(dest, queueName, null);
                }
            }
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.options, this.connection, this, consumer, noLocal, dest, (String)selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    private SimpleString createFQQNSubscription(ActiveMQDestination dest, SimpleString coreFilterString, ClientSession.AddressQuery response) throws ActiveMQException, JMSException {
        ClientSession.QueueQuery queueQuery;
        SimpleString queueName = CompositeAddress.extractQueueName(dest.getSimpleAddress());
        if (!response.isExists() || !response.getQueueNames().contains(AutoCreateUtil.getCoreQueueName(this.session, dest.getSimpleAddress()))) {
            if (response.isAutoCreateQueues()) {
                try {
                    this.createQueue(dest, RoutingType.MULTICAST, dest.getSimpleAddress(), coreFilterString, true, true, response);
                    return queueName;
                }
                catch (ActiveMQQueueExistsException activeMQQueueExistsException) {}
            } else {
                throw new InvalidDestinationException("Destination " + dest.getName() + " does not exist");
            }
        }
        if (!(queueQuery = this.session.queueQuery(queueName)).isExists()) {
            throw new InvalidDestinationException("Destination " + String.valueOf(queueName) + " does not exist");
        }
        if (coreFilterString != null && queueQuery.getFilterString() != null && !coreFilterString.equals(queueQuery.getFilterString())) {
            throw new JMSException(String.valueOf(queueName) + " filter mismatch [" + String.valueOf(coreFilterString) + "] is different than existing filter [" + String.valueOf(queueQuery.getFilterString()) + "]");
        }
        return queueName;
    }

    private ClientConsumer createClientConsumer(ActiveMQDestination destination, SimpleString queueName, SimpleString coreFilterString) throws ActiveMQException {
        QueueAttributes queueAttributes = Objects.requireNonNullElseGet(destination.getQueueAttributes(), () -> new QueueAttributes());
        int priority = Objects.requireNonNullElse(queueAttributes.getConsumerPriority(), ActiveMQDefaultConfiguration.getDefaultConsumerPriority());
        return this.session.createConsumer(queueName == null ? destination.getSimpleAddress() : queueName, coreFilterString, priority, false);
    }

    public void ackAllConsumers() throws JMSException {
        this.checkClosed();
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String filterString) throws JMSException {
        ActiveMQDestination activeMQDestination;
        block11: {
            if (this.sessionType == 2) {
                throw new IllegalStateException("Cannot create a browser on a TopicSession");
            }
            if (queue == null) {
                throw new InvalidDestinationException("Cannot create a browser with a null queue");
            }
            if (!(queue instanceof ActiveMQDestination)) {
                throw new InvalidDestinationException("Not an ActiveMQQueue:" + String.valueOf(queue));
            }
            activeMQDestination = (ActiveMQDestination)((Object)queue);
            if ("".equals(filterString)) {
                filterString = null;
            }
            try {
                if (filterString != null) {
                    SelectorParser.parse(filterString.trim());
                }
            }
            catch (FilterException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(ActiveMQJMSClientBundle.BUNDLE.invalidFilter(SimpleString.of(filterString), e));
            }
            if (!activeMQDestination.isQueue()) {
                throw new InvalidDestinationException("Cannot create a browser on a topic");
            }
            try {
                ClientSession.AddressQuery response = this.session.addressQuery(SimpleString.of(activeMQDestination.getAddress()));
                if (response.isExists()) break block11;
                if (response.isAutoCreateQueues()) {
                    this.createQueue(activeMQDestination, RoutingType.ANYCAST, activeMQDestination.getSimpleAddress(), null, true, true, response);
                    break block11;
                }
                throw new InvalidDestinationException("Destination " + activeMQDestination.getName() + " does not exist");
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
        return new ActiveMQQueueBrowser(this.options, (ActiveMQQueue)activeMQDestination, filterString, this.session, this.enable1xPrefixes);
    }

    @Override
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        try {
            ActiveMQTemporaryQueue queue = this.enable1xPrefixes ? ActiveMQDestination.createTemporaryQueue(this, PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()) : ActiveMQDestination.createTemporaryQueue(this);
            SimpleString simpleAddress = queue.getSimpleAddress();
            this.session.createQueue(QueueConfiguration.of(simpleAddress).setRoutingType(RoutingType.ANYCAST).setDurable(false).setTemporary(true));
            this.connection.addTemporaryQueue(simpleAddress);
            queue.setCreated(true);
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        try {
            ActiveMQTemporaryTopic topic = this.enable1xPrefixes ? ActiveMQDestination.createTemporaryTopic(this, PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()) : ActiveMQDestination.createTemporaryTopic(this);
            SimpleString simpleAddress = topic.getSimpleAddress();
            this.session.createQueue(QueueConfiguration.of(simpleAddress).setAddress(simpleAddress).setFilterString(REJECTING_FILTER).setDurable(false).setTemporary(true));
            this.connection.addTemporaryQueue(simpleAddress);
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        SimpleString queueName = ActiveMQDestination.createQueueNameForSubscription(true, this.connection.getClientID(), name);
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(queueName);
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot unsubscribe, subscription with name " + name + " does not exist");
            }
            if (response.getConsumerCount() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + name + " since it has active subscribers");
            }
            this.session.deleteQueue(queueName);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Session getSession() throws JMSException {
        if (!this.xa) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    @Override
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue, messageSelector);
    }

    @Override
    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue);
    }

    @Override
    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer(queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    @Override
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer(topic);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, noLocal);
    }

    @Override
    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "ActiveMQSession->" + String.valueOf(this.session);
    }

    public ClientSession getCoreSession() {
        return this.session;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public void deleteTemporaryTopic(ActiveMQDestination tempTopic) throws JMSException {
        if (!tempTopic.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary topic " + String.valueOf(tempTopic));
        }
        try {
            ClientSession.AddressQuery response = this.session.addressQuery(tempTopic.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary topic " + tempTopic.getName() + " does not exist");
            }
            if (response.getQueueNames().size() > 1) {
                throw new IllegalStateException("Cannot delete temporary topic " + tempTopic.getName() + " since it has subscribers");
            }
            SimpleString address = tempTopic.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void deleteTemporaryQueue(ActiveMQDestination tempQueue) throws JMSException {
        if (!tempQueue.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary queue " + String.valueOf(tempQueue));
        }
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(tempQueue.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary queue " + tempQueue.getName() + " does not exist");
            }
            if (response.getConsumerCount() > 0) {
                throw new IllegalStateException("Cannot delete temporary queue " + tempQueue.getName() + " since it has subscribers");
            }
            SimpleString address = tempQueue.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.session.start();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.session.stop();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void removeConsumer(ActiveMQMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    public boolean isEnable1xPrefixes() {
        return this.enable1xPrefixes;
    }

    void deleteQueue(SimpleString queueName) throws JMSException {
        if (!this.session.isClosed()) {
            try {
                this.session.deleteQueue(queueName);
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    void checkClosed() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    void createTemporaryQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, ClientSession.AddressQuery addressQuery) throws ActiveMQException {
        QueueConfiguration queueConfiguration = Objects.requireNonNullElse(destination.getQueueConfiguration(), QueueConfiguration.of(queueName));
        AutoCreateUtil.setRequiredQueueConfigurationIfNotSet(queueConfiguration, addressQuery, routingType, filter, false);
        this.session.createQueue(queueConfiguration.setName(queueName).setAddress(destination.getAddress()).setDurable(false).setTemporary(true));
    }

    void createSharedQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, ClientSession.AddressQuery addressQuery) throws ActiveMQException {
        QueueConfiguration queueConfiguration = Objects.requireNonNullElseGet(destination.getQueueConfiguration(), () -> QueueConfiguration.of(queueName));
        AutoCreateUtil.setRequiredQueueConfigurationIfNotSet(queueConfiguration, addressQuery, routingType, filter, durable);
        this.session.createSharedQueue(queueConfiguration.setName(queueName).setAddress(destination.getAddress()).setDurable(durable));
    }

    void createQueue(ActiveMQDestination destination, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean autoCreated, ClientSession.AddressQuery addressQuery) throws ActiveMQException {
        QueueConfiguration queueConfiguration = Objects.requireNonNullElseGet(destination.getQueueConfiguration(), () -> QueueConfiguration.of(queueName));
        AutoCreateUtil.setRequiredQueueConfigurationIfNotSet(queueConfiguration, addressQuery, routingType, filter, durable);
        this.session.createQueue(queueConfiguration.setName(queueName).setAddress(destination.getAddress()).setAutoCreated(autoCreated).setDurable(durable));
    }

    private ActiveMQQueue lookupQueue(String queueName, boolean isTemporary) throws ActiveMQException {
        ClientSession.QueueQuery response;
        Object queueNameToUse = queueName;
        if (this.enable1xPrefixes) {
            queueNameToUse = (isTemporary ? PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString() : PacketImpl.OLD_QUEUE_PREFIX.toString()) + queueName;
        }
        ActiveMQQueue queue = isTemporary ? ActiveMQDestination.createTemporaryQueue((String)queueNameToUse) : ActiveMQDestination.createQueue((String)queueNameToUse);
        if (queueName != queueNameToUse) {
            queue.setName(queueName);
        }
        if (!(response = this.session.queueQuery(queue.getSimpleAddress())).isExists() && !response.isAutoCreateQueues()) {
            return null;
        }
        return queue;
    }

    private ActiveMQTopic lookupTopic(String topicName, boolean isTemporary) throws ActiveMQException {
        ClientSession.AddressQuery query;
        Object topicNameToUse = topicName;
        if (this.enable1xPrefixes) {
            topicNameToUse = (isTemporary ? PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString() : PacketImpl.OLD_TOPIC_PREFIX.toString()) + topicName;
        }
        ActiveMQTopic topic = isTemporary ? ActiveMQDestination.createTemporaryTopic((String)topicNameToUse) : ActiveMQDestination.createTopic((String)topicNameToUse);
        if (topicNameToUse != topicName) {
            topic.setName(topicName);
        }
        if (!(query = this.session.addressQuery(topic.getSimpleAddress())).isExists() && !query.isAutoCreateAddresses()) {
            return null;
        }
        return topic;
    }

    static enum ConsumerDurability {
        DURABLE,
        NON_DURABLE;

    }
}

