/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class CreateAddressMessage
extends PacketImpl {
    private SimpleString address;
    private EnumSet<RoutingType> routingTypes;
    private boolean autoCreated;
    private boolean requiresResponse;

    public CreateAddressMessage(SimpleString address, EnumSet<RoutingType> routingTypes, boolean autoCreated, boolean requiresResponse) {
        this();
        this.address = address;
        this.routingTypes = routingTypes;
        this.autoCreated = autoCreated;
        this.requiresResponse = requiresResponse;
    }

    public CreateAddressMessage() {
        super((byte)-11);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", routingTypes=" + String.valueOf(this.routingTypes));
        sb.append(", autoCreated=" + this.autoCreated);
        return sb.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    public void setRoutingTypes(EnumSet<RoutingType> routingTypes) {
        this.routingTypes = routingTypes;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeInt(this.routingTypes.size());
        for (RoutingType routingType : this.routingTypes) {
            buffer.writeByte(routingType.getType());
        }
        buffer.writeBoolean(this.requiresResponse);
        buffer.writeBoolean(this.autoCreated);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        int routingTypeSetSize = buffer.readInt();
        this.routingTypes = EnumSet.noneOf(RoutingType.class);
        for (int i = 0; i < routingTypeSetSize; ++i) {
            this.routingTypes.add(RoutingType.getType(buffer.readByte()));
        }
        this.requiresResponse = buffer.readBoolean();
        this.autoCreated = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.address, this.routingTypes, this.autoCreated, this.requiresResponse);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateAddressMessage)) {
            return false;
        }
        CreateAddressMessage other = (CreateAddressMessage)obj;
        return Objects.equals(this.address, other.address) && Objects.equals(this.routingTypes, other.routingTypes) && this.autoCreated == other.autoCreated && this.requiresResponse == other.requiresResponse;
    }
}

