/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Arrays;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Digest;

public class MutableDigest
extends Digest {
    public MutableDigest(Address[] members) {
        super(members, MutableDigest.createEmptyArray(members.length * 2));
    }

    public MutableDigest(Digest digest) {
        super(digest);
    }

    public MutableDigest set(Address member, long highest_delivered_seqno, long highest_received_seqno) {
        if (member == null) {
            return this;
        }
        int index = this.find(member);
        if (index >= 0) {
            this.seqnos[index * 2] = highest_delivered_seqno;
            this.seqnos[index * 2 + 1] = highest_received_seqno;
        }
        return this;
    }

    public boolean allSet() {
        for (int i = 0; i < this.seqnos.length; i += 2) {
            if (this.seqnos[i] != -1L) continue;
            return false;
        }
        return true;
    }

    public Address[] getNonSetMembers() {
        Address[] retval = new Address[this.countNonSetMembers()];
        if (retval.length == 0) {
            return retval;
        }
        int index = 0;
        for (int i = 0; i < this.members.length; ++i) {
            if (this.seqnos[i * 2] != -1L) continue;
            retval[index++] = this.members[i];
        }
        return retval;
    }

    public MutableDigest set(Digest digest) {
        if (digest == null) {
            return this;
        }
        for (Digest.Entry entry : digest) {
            this.set(entry.getMember(), entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno());
        }
        return this;
    }

    public MutableDigest merge(Digest digest) {
        if (digest == null) {
            return this;
        }
        for (Digest.Entry entry : digest) {
            this.merge(entry.getMember(), entry.getHighestDeliveredSeqno(), entry.getHighestReceivedSeqno());
        }
        return this;
    }

    public MutableDigest merge(Address member, long highest_delivered_seqno, long highest_received_seqno) {
        if (member == null) {
            return this;
        }
        long[] entry = this.get(member);
        long hd = entry == null ? highest_delivered_seqno : Math.max(entry[0], highest_delivered_seqno);
        long hr = entry == null ? highest_received_seqno : Math.max(entry[1], highest_received_seqno);
        return this.set(member, hd, hr);
    }

    protected static long[] createEmptyArray(int size) {
        long[] retval = new long[size];
        Arrays.fill(retval, -1L);
        return retval;
    }

    protected int countNonSetMembers() {
        int retval = 0;
        for (int i = 0; i < this.seqnos.length; i += 2) {
            if (this.seqnos[i] != -1L) continue;
            ++retval;
        }
        return retval;
    }
}

