/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
implements DataInput {
    protected final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.get(b, off, len);
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buf.limit() - this.buf.position());
        this.buf.position(this.buf.position() + skip);
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.readByte() & 0xFF;
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int retval = this.readShort() & 0xFFFF;
        if (retval < 0) {
            throw new EOFException();
        }
        return retval;
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public String readLine() throws IOException {
        byte c;
        char[] lineBuffer = new char[128];
        char[] buffer = lineBuffer;
        if (buffer == null) {
            buffer = lineBuffer = new char[128];
        }
        int room = buffer.length;
        int offset = 0;
        block4: while (true) {
            c = this.readByte();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    byte c2 = this.readByte();
                    if (c2 == 10 || c2 == -1) break block4;
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        buffer = new char[offset + 128];
                        room = buffer.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buffer, 0, offset);
                        lineBuffer = buffer;
                    }
                    buffer[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buffer, 0, offset);
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public String toString() {
        return this.buf.toString();
    }
}

